// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceApplyHoldRequest;
import com.microsoft.graph.security.models.EdiscoveryNoncustodialDataSource;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.security.models.EdiscoveryNoncustodialDataSourceApplyHoldParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Noncustodial Data Source Apply Hold Request Builder.
 */
public class EdiscoveryNoncustodialDataSourceApplyHoldRequestBuilder extends BaseActionRequestBuilder<EdiscoveryNoncustodialDataSource> {

    private EdiscoveryNoncustodialDataSourceApplyHoldParameterSet body;
    /**
     * The request builder for this EdiscoveryNoncustodialDataSourceApplyHold
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public EdiscoveryNoncustodialDataSourceApplyHoldRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final EdiscoveryNoncustodialDataSourceApplyHoldParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }
    /**
     * The request builder for this EdiscoveryNoncustodialDataSourceApplyHold
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryNoncustodialDataSourceApplyHoldRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the EdiscoveryNoncustodialDataSourceApplyHoldRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryNoncustodialDataSourceApplyHoldRequest instance
     */
    @Nonnull
    public EdiscoveryNoncustodialDataSourceApplyHoldRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoveryNoncustodialDataSourceApplyHoldRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryNoncustodialDataSourceApplyHoldRequest instance
     */
    @Nonnull
    public EdiscoveryNoncustodialDataSourceApplyHoldRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoveryNoncustodialDataSourceApplyHoldRequest request = new EdiscoveryNoncustodialDataSourceApplyHoldRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
