// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryTagOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Tag Operation Request.
 */
public class EdiscoveryTagOperationRequest extends BaseRequest<EdiscoveryTagOperation> {
	
    /**
     * The request for the EdiscoveryTagOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryTagOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryTagOperation.class);
    }

    /**
     * Gets the EdiscoveryTagOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryTagOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryTagOperation from the service
     *
     * @return the EdiscoveryTagOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryTagOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryTagOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryTagOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryTagOperation with a source
     *
     * @param sourceEdiscoveryTagOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryTagOperation> patchAsync(@Nonnull final EdiscoveryTagOperation sourceEdiscoveryTagOperation) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryTagOperation);
    }

    /**
     * Patches this EdiscoveryTagOperation with a source
     *
     * @param sourceEdiscoveryTagOperation the source object with updates
     * @return the updated EdiscoveryTagOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryTagOperation patch(@Nonnull final EdiscoveryTagOperation sourceEdiscoveryTagOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryTagOperation);
    }

    /**
     * Creates a EdiscoveryTagOperation with a new object
     *
     * @param newEdiscoveryTagOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryTagOperation> postAsync(@Nonnull final EdiscoveryTagOperation newEdiscoveryTagOperation) {
        return sendAsync(HttpMethod.POST, newEdiscoveryTagOperation);
    }

    /**
     * Creates a EdiscoveryTagOperation with a new object
     *
     * @param newEdiscoveryTagOperation the new object to create
     * @return the created EdiscoveryTagOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryTagOperation post(@Nonnull final EdiscoveryTagOperation newEdiscoveryTagOperation) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryTagOperation);
    }

    /**
     * Creates a EdiscoveryTagOperation with a new object
     *
     * @param newEdiscoveryTagOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryTagOperation> putAsync(@Nonnull final EdiscoveryTagOperation newEdiscoveryTagOperation) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryTagOperation);
    }

    /**
     * Creates a EdiscoveryTagOperation with a new object
     *
     * @param newEdiscoveryTagOperation the object to create/update
     * @return the created EdiscoveryTagOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryTagOperation put(@Nonnull final EdiscoveryTagOperation newEdiscoveryTagOperation) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryTagOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryTagOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryTagOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

