// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.HostCookie;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Cookie Request.
 */
public class HostCookieRequest extends BaseRequest<HostCookie> {
	
    /**
     * The request for the HostCookie
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public HostCookieRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostCookie.class);
    }

    /**
     * Gets the HostCookie from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostCookie> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the HostCookie from the service
     *
     * @return the HostCookie from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostCookie get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostCookie> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public HostCookie delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this HostCookie with a source
     *
     * @param sourceHostCookie the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostCookie> patchAsync(@Nonnull final HostCookie sourceHostCookie) {
        return sendAsync(HttpMethod.PATCH, sourceHostCookie);
    }

    /**
     * Patches this HostCookie with a source
     *
     * @param sourceHostCookie the source object with updates
     * @return the updated HostCookie
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostCookie patch(@Nonnull final HostCookie sourceHostCookie) throws ClientException {
        return send(HttpMethod.PATCH, sourceHostCookie);
    }

    /**
     * Creates a HostCookie with a new object
     *
     * @param newHostCookie the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostCookie> postAsync(@Nonnull final HostCookie newHostCookie) {
        return sendAsync(HttpMethod.POST, newHostCookie);
    }

    /**
     * Creates a HostCookie with a new object
     *
     * @param newHostCookie the new object to create
     * @return the created HostCookie
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostCookie post(@Nonnull final HostCookie newHostCookie) throws ClientException {
        return send(HttpMethod.POST, newHostCookie);
    }

    /**
     * Creates a HostCookie with a new object
     *
     * @param newHostCookie the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostCookie> putAsync(@Nonnull final HostCookie newHostCookie) {
        return sendAsync(HttpMethod.PUT, newHostCookie);
    }

    /**
     * Creates a HostCookie with a new object
     *
     * @param newHostCookie the object to create/update
     * @return the created HostCookie
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostCookie put(@Nonnull final HostCookie newHostCookie) throws ClientException {
        return send(HttpMethod.PUT, newHostCookie);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public HostCookieRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public HostCookieRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

