// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Indicator;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Indicator Request.
 */
public class IndicatorRequest extends BaseRequest<Indicator> {
	
    /**
     * The request for the Indicator
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public IndicatorRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends Indicator> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the Indicator
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IndicatorRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Indicator.class);
    }

    /**
     * Gets the Indicator from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Indicator> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Indicator from the service
     *
     * @return the Indicator from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Indicator get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Indicator> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Indicator delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Indicator with a source
     *
     * @param sourceIndicator the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Indicator> patchAsync(@Nonnull final Indicator sourceIndicator) {
        return sendAsync(HttpMethod.PATCH, sourceIndicator);
    }

    /**
     * Patches this Indicator with a source
     *
     * @param sourceIndicator the source object with updates
     * @return the updated Indicator
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Indicator patch(@Nonnull final Indicator sourceIndicator) throws ClientException {
        return send(HttpMethod.PATCH, sourceIndicator);
    }

    /**
     * Creates a Indicator with a new object
     *
     * @param newIndicator the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Indicator> postAsync(@Nonnull final Indicator newIndicator) {
        return sendAsync(HttpMethod.POST, newIndicator);
    }

    /**
     * Creates a Indicator with a new object
     *
     * @param newIndicator the new object to create
     * @return the created Indicator
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Indicator post(@Nonnull final Indicator newIndicator) throws ClientException {
        return send(HttpMethod.POST, newIndicator);
    }

    /**
     * Creates a Indicator with a new object
     *
     * @param newIndicator the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Indicator> putAsync(@Nonnull final Indicator newIndicator) {
        return sendAsync(HttpMethod.PUT, newIndicator);
    }

    /**
     * Creates a Indicator with a new object
     *
     * @param newIndicator the object to create/update
     * @return the created Indicator
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Indicator put(@Nonnull final Indicator newIndicator) throws ClientException {
        return send(HttpMethod.PUT, newIndicator);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IndicatorRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IndicatorRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

