/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.mashape.unirest.http.Unirest;
import com.moesif.api.MoesifAPIClient;
import com.moesif.api.exceptions.APIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class APIHelper {
    private static ExecutorService scheduler = null;
    private static Object syncRoot = new Object();
    public static ObjectMapper mapper = new ObjectMapper(){
        private static final long serialVersionUID = -174113593500315394L;
        {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    };
    private static final Set<Class> WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, String.class, Integer.class, Long.class, Float.class, Double.class, Void.class, File.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getScheduler() {
        Object object = syncRoot;
        synchronized (object) {
            if (null == scheduler) {
                scheduler = Executors.newCachedThreadPool();
            }
            return scheduler;
        }
    }

    public static void shutdown() {
        if (null != scheduler) {
            scheduler.shutdown();
        }
        try {
            Unirest.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Date parseDate(String date) throws ParseException {
        return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
    }

    public static String dateToString(Date date) {
        return ISO8601Utils.format((Date)date);
    }

    public static String serialize(Object obj) throws JsonProcessingException {
        if (null == obj) {
            return null;
        }
        return mapper.writeValueAsString(obj);
    }

    public static <T> T deserialize(String json, TypeReference<T> typeReference) throws IOException {
        if (APIHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, typeReference);
    }

    public static <T> T deserialize(String json, Class<T> typeReference) throws IOException {
        if (APIHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, typeReference);
    }

    public static void populate(String json, APIException obj) throws IOException {
        if (!APIHelper.isNullOrWhiteSpace(json)) {
            mapper.readerForUpdating((Object)obj).readValue(json);
        }
    }

    public static LinkedHashMap<String, Object> deserialize(String json) throws IOException {
        if (APIHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
        return APIHelper.deserialize(json, typeRef);
    }

    public static void appendUrlWithTemplateParameters(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (null == queryBuilder) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (null == parameters) {
            return;
        }
        for (Map.Entry<String, Object> pair : parameters.entrySet()) {
            String replaceValue = "";
            replaceValue = null == pair.getValue() ? "" : (pair.getValue() instanceof Collection ? APIHelper.flattenCollection("", (Collection)pair.getValue(), "%s%s%s", '/') : (pair.getValue() instanceof Date ? APIHelper.tryUrlEncode(APIHelper.dateToString((Date)pair.getValue())) : APIHelper.tryUrlEncode(pair.getValue().toString())));
            APIHelper.replaceAll(queryBuilder, "{" + pair.getKey() + "}", replaceValue);
        }
    }

    public static void appendUrlWithQueryParameters(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (null == queryBuilder) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (null == parameters) {
            return;
        }
        boolean hasParams = queryBuilder.indexOf("?") > 0 || queryBuilder.indexOf("http") != 0;
        queryBuilder.append(hasParams ? (char)'&' : '?');
        APIHelper.encodeObjectAsQueryString("", parameters, queryBuilder);
    }

    public static boolean isNullOrWhiteSpace(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length > 0) {
            int start = 0;
            int middle = length / 2;
            int end = length - 1;
            while (start <= middle) {
                if (s.charAt(start) > ' ' || s.charAt(end) > ' ') {
                    return false;
                }
                ++start;
                --end;
            }
            return true;
        }
        return false;
    }

    public static void replaceAll(StringBuilder stringBuilder, String toReplace, String replaceWith) {
        int index = stringBuilder.indexOf(toReplace);
        while (index != -1) {
            stringBuilder.replace(index, index + toReplace.length(), replaceWith);
            index += replaceWith.length();
            index = stringBuilder.indexOf(toReplace, index);
        }
    }

    public static void removeNullValues(Map<String, ?> map) {
        if (map == null) {
            return;
        }
        map.values().removeAll(Collections.singleton(null));
    }

    public static String cleanUrl(StringBuilder url) {
        Pattern pattern = Pattern.compile("^(https?://[^/]+)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid Url format.");
        }
        String protocol = matcher.group(1);
        String query = url.substring(protocol.length());
        query = query.replaceAll("//+", "/");
        return protocol.concat(query);
    }

    public static Map<String, Object> prepareFormFields(Object value) {
        LinkedHashMap<String, Object> formFields = new LinkedHashMap<String, Object>();
        if (value != null) {
            try {
                APIHelper.objectToMap("", value, formFields, new HashSet<Integer>());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return formFields;
    }

    public static synchronized String getVersion() {
        String mavenPackage = "com.moesif";
        String mavenArtifact = "moesifapi-java";
        try {
            String className = MoesifAPIClient.class.getName();
            String classfileName = "/" + className.replace('.', '/') + ".class";
            URL classfileResource = MoesifAPIClient.class.getResource(classfileName);
            if (classfileResource != null) {
                Path absolutePackagePath = Paths.get(classfileResource.toURI()).getParent();
                int packagePathSegments = className.length() - className.replace(".", "").length();
                Path path = absolutePackagePath;
                int segmentsToRemove = packagePathSegments + 2;
                for (int i = 0; i < segmentsToRemove; ++i) {
                    path = path.getParent();
                }
                Path pom = path.resolve("pom.xml");
                InputStream is = Files.newInputStream(pom, new OpenOption[0]);
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                doc.getDocumentElement().normalize();
                String version = (String)XPathFactory.newInstance().newXPath().compile("/project/version").evaluate(doc, XPathConstants.STRING);
                if (version != null && !(version = version.trim()).isEmpty()) {
                    return version;
                }
            }
        }
        catch (Exception className) {
            // empty catch block
        }
        try {
            InputStream is = MoesifAPIClient.class.getResourceAsStream("/META-INF/maven/" + mavenPackage + "/" + mavenArtifact + "/pom.properties");
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                String version = p.getProperty("version", "").trim();
                if (!version.isEmpty()) {
                    return version;
                }
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        String version = null;
        Package pkg = MoesifAPIClient.class.getPackage();
        if (pkg != null && (version = pkg.getImplementationVersion()) == null) {
            version = pkg.getSpecificationVersion();
        }
        version = version == null ? "" : version.trim();
        return version.isEmpty() ? "unknown" : version;
    }

    private static void encodeObjectAsQueryString(String name, Object obj, StringBuilder objBuilder) {
        try {
            if (obj == null) {
                return;
            }
            LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>();
            APIHelper.objectToMap(name, obj, objectMap, new HashSet<Integer>());
            boolean hasParam = false;
            for (Map.Entry pair : objectMap.entrySet()) {
                Object value = pair.getValue();
                if (value == null) continue;
                hasParam = true;
                String paramKeyValPair = String.format("%s=%s&", pair.getKey(), APIHelper.tryUrlEncode(value.toString()));
                objBuilder.append(paramKeyValPair);
            }
            if (hasParam) {
                objBuilder.setLength(objBuilder.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String flattenCollection(String elemName, Collection<?> array, String fmt, char separator) {
        StringBuilder builder = new StringBuilder();
        for (Object element : array) {
            String elemValue = null;
            elemValue = null == element ? "" : (element instanceof Date ? APIHelper.dateToString((Date)element) : element.toString());
            elemValue = APIHelper.tryUrlEncode(elemValue);
            builder.append(String.format(fmt, elemName, elemValue, Character.valueOf(separator)));
        }
        if (builder.length() > 1 && builder.charAt(builder.length() - 1) == separator) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static String tryUrlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception ex) {
            return value;
        }
    }

    private static void objectToMap(String objName, Object obj, Map<String, Object> objectMap, HashSet<Integer> processed) throws InvalidObjectException {
        if (obj == null) {
            return;
        }
        if (!APIHelper.isWrapperType(obj.getClass())) {
            if (processed.contains(obj.hashCode())) {
                return;
            }
            processed.add(obj.hashCode());
        }
        if (obj instanceof Collection) {
            if (objName == null || objName.isEmpty()) {
                throw new InvalidObjectException("Object name cannot be empty");
            }
            Collection array = (Collection)obj;
            int index = 0;
            for (Object element : array) {
                String key = String.format("%s[%d]", objName, index++);
                APIHelper.loadKeyValuePairForEncoding(key, element, objectMap, processed);
            }
        } else if (obj.getClass().isArray()) {
            if (objName == null || objName.isEmpty()) {
                throw new InvalidObjectException("Object name cannot be empty");
            }
            Object[] array = (Object[])obj;
            int index = 0;
            for (Object element : array) {
                String key = String.format("%s[%d]", objName, index++);
                APIHelper.loadKeyValuePairForEncoding(key, element, objectMap, processed);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry pair : map.entrySet()) {
                String attribName;
                String key = attribName = pair.getKey().toString();
                if (objName != null && !objName.isEmpty()) {
                    key = String.format("%s[%s]", objName, attribName);
                }
                APIHelper.loadKeyValuePairForEncoding(key, pair.getValue(), objectMap, processed);
            }
        } else if (obj instanceof UUID) {
            String key = objName;
            String value = obj.toString();
            APIHelper.loadKeyValuePairForEncoding(key, value, objectMap, processed);
        } else if (obj instanceof Date) {
            String key = objName;
            String value = APIHelper.dateToString((Date)obj);
            APIHelper.loadKeyValuePairForEncoding(key, value, objectMap, processed);
        } else {
            Field[] fields;
            Object value;
            String key;
            String attribName;
            Method[] methods;
            for (Method method : methods = obj.getClass().getMethods()) {
                JsonGetter getterAnnotation;
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") || (getterAnnotation = method.getAnnotation(JsonGetter.class)) == null) continue;
                key = attribName = getterAnnotation.value();
                if (objName != null && !objName.isEmpty()) {
                    key = String.format("%s[%s]", objName, attribName);
                }
                try {
                    value = method.invoke(obj, new Object[0]);
                    APIHelper.loadKeyValuePairForEncoding(key, value, objectMap, processed);
                }
                catch (Exception value2) {
                    // empty catch block
                }
            }
            for (Field field : fields = obj.getClass().getFields()) {
                key = attribName = field.getName();
                if (objName != null && !objName.isEmpty()) {
                    key = String.format("%s[%s]", objName, attribName);
                }
                try {
                    value = field.get(obj);
                    APIHelper.loadKeyValuePairForEncoding(key, value, objectMap, processed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, Map<String, Object> objectMap, HashSet<Integer> processed) throws InvalidObjectException {
        if (value == null) {
            return;
        }
        if (APIHelper.isWrapperType(value.getClass())) {
            objectMap.put(key, value);
        } else {
            APIHelper.objectToMap(key, value, objectMap, processed);
        }
    }

    private static boolean isWrapperType(Class clazz) {
        return WRAPPER_TYPES.contains(clazz) || clazz.isPrimitive() || clazz.isEnum();
    }
}

