/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpAddress {
    private static Pattern PRIVATE_ADDRESS_PATTERN = Pattern.compile("(^127\\.)|(^192\\.168\\.)|(^10\\.)|(^172\\.1[6-9]\\.)|(^172\\.2[0-9]\\.)|(^172\\.3[0-1]\\.)|(^::1$)|(^[fF][cCdD])", 128);

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !IpAddress.isEmpty(cs);
    }

    public static String getClientIp(Map<String, String> headers, String remoteAddr) {
        try {
            String header = IpAddress.getClientIpFromHeader(headers.get("x-client-ip"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("client-ip"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("x-forwarded-for"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("cf-connecting-ip"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("fastly-client-ip"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("true-client-ip"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("x-real-ip"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("x-cluster-client-ip"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("x-forwarded"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("forwarded-for"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            header = IpAddress.getClientIpFromHeader(headers.get("forwarded"));
            if (IpAddress.isNotEmpty(header)) {
                return header;
            }
            return remoteAddr;
        }
        catch (Exception e) {
            return remoteAddr;
        }
    }

    private static String getClientIpFromHeader(String header) {
        if (IpAddress.isEmpty(header)) {
            return null;
        }
        String firstValue = header.split(",")[0];
        if (IpAddress.isEmpty(firstValue) || IpAddress.isPrivateOrLocalAddress(firstValue)) {
            return null;
        }
        return firstValue;
    }

    private static boolean isPrivateOrLocalAddress(String address) {
        Matcher regexMatcher = PRIVATE_ADDRESS_PATTERN.matcher(address);
        return regexMatcher.matches();
    }
}

