/*
 * MoesifAPILib
 *
 *
 */
package com.moesif.api.controllers;

import com.moesif.api.exceptions.*;
import com.moesif.api.http.client.HttpClient;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.client.HttpCallBack;
import com.moesif.api.http.client.UnirestClient;
import com.moesif.api.http.response.HttpResponse;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

public abstract class BaseController {
    /**
     * Private variable to keep shared reference of client instance
     */
    private static HttpClient clientInstance = null;
    private static Object syncObject = new Object();

    /**
     * Protected variable to keep reference of httpCallBack instance if user provides any
     */
    protected HttpCallBack httpCallBack = null;
    
    /**
     * Get httpCallBack associated with this controller
     * @return HttpCallBack
     */
    public HttpCallBack getHttpCallBack() {
        return httpCallBack;
    }
    
    /**
     * Set the httpCallBack for this controller
     * @param httpCallBack called after HTTP response is received
     */
    public void setHttpCallBack(HttpCallBack httpCallBack) {
        this.httpCallBack = httpCallBack;
    }

    /**
     * Shared instance of the Http client
     * @return The shared instance of the http client 
     */
    public static HttpClient getClientInstance() {
        synchronized (syncObject) {
            if (null == clientInstance) {
        clientInstance = UnirestClient.getSharedInstance();
    }
        }
        return clientInstance;
    }

    /**
     * Shared instance of the Http client
     * @param    client    The shared instance of the http client 
     */
    public static void setClientInstance(HttpClient client) {
        synchronized (syncObject) {
            if (null != client) {
                clientInstance = client;
            }
        }
    }

    /**
     * Validates the response against HTTP errors defined at the API level
     * @param   response    The response recieved
     * @param   context     Context of the request and the recieved response
     * @throws APIException invalid response
     */
    protected void validateResponse(HttpResponse response, HttpContext context) 
            throws APIException {
        //get response status code to validate
        int responseCode = response.getStatusCode();
        if ((responseCode < 200) || (responseCode > 206)) {//[200,206] = HTTP OK
            String responseBody = "";
            try {
                String b = new BufferedReader(new InputStreamReader(response.getRawBody()))
                                            .lines().collect(Collectors.joining("\n"));
                if (null != b)
                    responseBody = b.length() > 400 ? b.substring(0, 400) : b;
            } catch (Exception ex) {}
            throw new APIException("HTTP Response [" + responseCode + "] Not OK: " + responseBody, context);
        }
    }
}
