/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+10xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X10 {

    public static final String[] map = new String[]{
        "k", // 0x00
        "kh", // 0x01
        "g", // 0x02
        "gh", // 0x03
        "ng", // 0x04
        "c", // 0x05
        "ch", // 0x06
        "j", // 0x07
        "jh", // 0x08
        "ny", // 0x09
        "nny", // 0x0a
        "tt", // 0x0b
        "tth", // 0x0c
        "dd", // 0x0d
        "ddh", // 0x0e
        "nn", // 0x0f
        "tt", // 0x10
        "th", // 0x11
        "d", // 0x12
        "dh", // 0x13
        "n", // 0x14
        "p", // 0x15
        "ph", // 0x16
        "b", // 0x17
        "bh", // 0x18
        "m", // 0x19
        "y", // 0x1a
        "r", // 0x1b
        "l", // 0x1c
        "w", // 0x1d
        "s", // 0x1e
        "h", // 0x1f
        "ll", // 0x20
        "a", // 0x21
        "[?]", // 0x22
        "i", // 0x23
        "ii", // 0x24
        "u", // 0x25
        "uu", // 0x26
        "e", // 0x27
        "[?]", // 0x28
        "o", // 0x29
        "au", // 0x2a
        "[?]", // 0x2b
        "aa", // 0x2c
        "i", // 0x2d
        "ii", // 0x2e
        "u", // 0x2f
        "uu", // 0x30
        "e", // 0x31
        "ai", // 0x32
        "[?]", // 0x33
        "[?]", // 0x34
        "[?]", // 0x35
        "N", // 0x36
        "\'", // 0x37
        ":", // 0x38
        "", // 0x39
        "[?]", // 0x3a
        "[?]", // 0x3b
        "[?]", // 0x3c
        "[?]", // 0x3d
        "[?]", // 0x3e
        "[?]", // 0x3f
        "0", // 0x40
        "1", // 0x41
        "2", // 0x42
        "3", // 0x43
        "4", // 0x44
        "5", // 0x45
        "6", // 0x46
        "7", // 0x47
        "8", // 0x48
        "9", // 0x49
        " / ", // 0x4a
        " // ", // 0x4b
        "n*", // 0x4c
        "r*", // 0x4d
        "l*", // 0x4e
        "e*", // 0x4f
        "sh", // 0x50
        "ss", // 0x51
        "R", // 0x52
        "RR", // 0x53
        "L", // 0x54
        "LL", // 0x55
        "R", // 0x56
        "RR", // 0x57
        "L", // 0x58
        "LL", // 0x59
        "[?]", // 0x5a
        "[?]", // 0x5b
        "[?]", // 0x5c
        "[?]", // 0x5d
        "[?]", // 0x5e
        "[?]", // 0x5f
        "[?]", // 0x60
        "[?]", // 0x61
        "[?]", // 0x62
        "[?]", // 0x63
        "[?]", // 0x64
        "[?]", // 0x65
        "[?]", // 0x66
        "[?]", // 0x67
        "[?]", // 0x68
        "[?]", // 0x69
        "[?]", // 0x6a
        "[?]", // 0x6b
        "[?]", // 0x6c
        "[?]", // 0x6d
        "[?]", // 0x6e
        "[?]", // 0x6f
        "[?]", // 0x70
        "[?]", // 0x71
        "[?]", // 0x72
        "[?]", // 0x73
        "[?]", // 0x74
        "[?]", // 0x75
        "[?]", // 0x76
        "[?]", // 0x77
        "[?]", // 0x78
        "[?]", // 0x79
        "[?]", // 0x7a
        "[?]", // 0x7b
        "[?]", // 0x7c
        "[?]", // 0x7d
        "[?]", // 0x7e
        "[?]", // 0x7f
        "[?]", // 0x80
        "[?]", // 0x81
        "[?]", // 0x82
        "[?]", // 0x83
        "[?]", // 0x84
        "[?]", // 0x85
        "[?]", // 0x86
        "[?]", // 0x87
        "[?]", // 0x88
        "[?]", // 0x89
        "[?]", // 0x8a
        "[?]", // 0x8b
        "[?]", // 0x8c
        "[?]", // 0x8d
        "[?]", // 0x8e
        "[?]", // 0x8f
        "[?]", // 0x90
        "[?]", // 0x91
        "[?]", // 0x92
        "[?]", // 0x93
        "[?]", // 0x94
        "[?]", // 0x95
        "[?]", // 0x96
        "[?]", // 0x97
        "[?]", // 0x98
        "[?]", // 0x99
        "[?]", // 0x9a
        "[?]", // 0x9b
        "[?]", // 0x9c
        "[?]", // 0x9d
        "[?]", // 0x9e
        "[?]", // 0x9f
        "A", // 0xa0
        "B", // 0xa1
        "G", // 0xa2
        "D", // 0xa3
        "E", // 0xa4
        "V", // 0xa5
        "Z", // 0xa6
        "T`", // 0xa7
        "I", // 0xa8
        "K", // 0xa9
        "L", // 0xaa
        "M", // 0xab
        "N", // 0xac
        "O", // 0xad
        "P", // 0xae
        "Zh", // 0xaf
        "R", // 0xb0
        "S", // 0xb1
        "T", // 0xb2
        "U", // 0xb3
        "P`", // 0xb4
        "K`", // 0xb5
        "G\'", // 0xb6
        "Q", // 0xb7
        "Sh", // 0xb8
        "Ch`", // 0xb9
        "C`", // 0xba
        "Z\'", // 0xbb
        "C", // 0xbc
        "Ch", // 0xbd
        "X", // 0xbe
        "J", // 0xbf
        "H", // 0xc0
        "E", // 0xc1
        "Y", // 0xc2
        "W", // 0xc3
        "Xh", // 0xc4
        "OE", // 0xc5
        "[?]", // 0xc6
        "[?]", // 0xc7
        "[?]", // 0xc8
        "[?]", // 0xc9
        "[?]", // 0xca
        "[?]", // 0xcb
        "[?]", // 0xcc
        "[?]", // 0xcd
        "[?]", // 0xce
        "[?]", // 0xcf
        "a", // 0xd0
        "b", // 0xd1
        "g", // 0xd2
        "d", // 0xd3
        "e", // 0xd4
        "v", // 0xd5
        "z", // 0xd6
        "t`", // 0xd7
        "i", // 0xd8
        "k", // 0xd9
        "l", // 0xda
        "m", // 0xdb
        "n", // 0xdc
        "o", // 0xdd
        "p", // 0xde
        "zh", // 0xdf
        "r", // 0xe0
        "s", // 0xe1
        "t", // 0xe2
        "u", // 0xe3
        "p`", // 0xe4
        "k`", // 0xe5
        "g\'", // 0xe6
        "q", // 0xe7
        "sh", // 0xe8
        "ch`", // 0xe9
        "c`", // 0xea
        "z\'", // 0xeb
        "c", // 0xec
        "ch", // 0xed
        "x", // 0xee
        "j", // 0xef
        "h", // 0xf0
        "e", // 0xf1
        "y", // 0xf2
        "w", // 0xf3
        "xh", // 0xf4
        "oe", // 0xf5
        "f", // 0xf6
        "[?]", // 0xf7
        "[?]", // 0xf8
        "[?]", // 0xf9
        "[?]", // 0xfa
        " // ", // 0xfb
        "[?]", // 0xfc
        "[?]", // 0xfd
        "[?]" // 0xfe
    };
}
