/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+18xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X18 {

    public static final String[] map = new String[]{
        " @ ", // 0x00
        " ... ", // 0x01
        ", ", // 0x02
        ". ", // 0x03
        ": ", // 0x04
        " // ", // 0x05
        "", // 0x06
        "-", // 0x07
        ", ", // 0x08
        ". ", // 0x09
        "", // 0x0a
        "", // 0x0b
        "", // 0x0c
        "", // 0x0d
        "", // 0x0e
        "[?]", // 0x0f
        "0", // 0x10
        "1", // 0x11
        "2", // 0x12
        "3", // 0x13
        "4", // 0x14
        "5", // 0x15
        "6", // 0x16
        "7", // 0x17
        "8", // 0x18
        "9", // 0x19
        "[?]", // 0x1a
        "[?]", // 0x1b
        "[?]", // 0x1c
        "[?]", // 0x1d
        "[?]", // 0x1e
        "[?]", // 0x1f
        "a", // 0x20
        "e", // 0x21
        "i", // 0x22
        "o", // 0x23
        "u", // 0x24
        "O", // 0x25
        "U", // 0x26
        "ee", // 0x27
        "n", // 0x28
        "ng", // 0x29
        "b", // 0x2a
        "p", // 0x2b
        "q", // 0x2c
        "g", // 0x2d
        "m", // 0x2e
        "l", // 0x2f
        "s", // 0x30
        "sh", // 0x31
        "t", // 0x32
        "d", // 0x33
        "ch", // 0x34
        "j", // 0x35
        "y", // 0x36
        "r", // 0x37
        "w", // 0x38
        "f", // 0x39
        "k", // 0x3a
        "kha", // 0x3b
        "ts", // 0x3c
        "z", // 0x3d
        "h", // 0x3e
        "zr", // 0x3f
        "lh", // 0x40
        "zh", // 0x41
        "ch", // 0x42
        "-", // 0x43
        "e", // 0x44
        "i", // 0x45
        "o", // 0x46
        "u", // 0x47
        "O", // 0x48
        "U", // 0x49
        "ng", // 0x4a
        "b", // 0x4b
        "p", // 0x4c
        "q", // 0x4d
        "g", // 0x4e
        "m", // 0x4f
        "t", // 0x50
        "d", // 0x51
        "ch", // 0x52
        "j", // 0x53
        "ts", // 0x54
        "y", // 0x55
        "w", // 0x56
        "k", // 0x57
        "g", // 0x58
        "h", // 0x59
        "jy", // 0x5a
        "ny", // 0x5b
        "dz", // 0x5c
        "e", // 0x5d
        "i", // 0x5e
        "iy", // 0x5f
        "U", // 0x60
        "u", // 0x61
        "ng", // 0x62
        "k", // 0x63
        "g", // 0x64
        "h", // 0x65
        "p", // 0x66
        "sh", // 0x67
        "t", // 0x68
        "d", // 0x69
        "j", // 0x6a
        "f", // 0x6b
        "g", // 0x6c
        "h", // 0x6d
        "ts", // 0x6e
        "z", // 0x6f
        "r", // 0x70
        "ch", // 0x71
        "zh", // 0x72
        "i", // 0x73
        "k", // 0x74
        "r", // 0x75
        "f", // 0x76
        "zh", // 0x77
        "[?]", // 0x78
        "[?]", // 0x79
        "[?]", // 0x7a
        "[?]", // 0x7b
        "[?]", // 0x7c
        "[?]", // 0x7d
        "[?]", // 0x7e
        "[?]", // 0x7f
        "[?]", // 0x80
        "H", // 0x81
        "X", // 0x82
        "W", // 0x83
        "M", // 0x84
        " 3 ", // 0x85
        " 333 ", // 0x86
        "a", // 0x87
        "i", // 0x88
        "k", // 0x89
        "ng", // 0x8a
        "c", // 0x8b
        "tt", // 0x8c
        "tth", // 0x8d
        "dd", // 0x8e
        "nn", // 0x8f
        "t", // 0x90
        "d", // 0x91
        "p", // 0x92
        "ph", // 0x93
        "ss", // 0x94
        "zh", // 0x95
        "z", // 0x96
        "a", // 0x97
        "t", // 0x98
        "zh", // 0x99
        "gh", // 0x9a
        "ng", // 0x9b
        "c", // 0x9c
        "jh", // 0x9d
        "tta", // 0x9e
        "ddh", // 0x9f
        "t", // 0xa0
        "dh", // 0xa1
        "ss", // 0xa2
        "cy", // 0xa3
        "zh", // 0xa4
        "z", // 0xa5
        "u", // 0xa6
        "y", // 0xa7
        "bh", // 0xa8
        "\'", // 0xa9
        "[?]", // 0xaa
        "[?]", // 0xab
        "[?]", // 0xac
        "[?]", // 0xad
        "[?]", // 0xae
        "[?]", // 0xaf
        "[?]", // 0xb0
        "[?]", // 0xb1
        "[?]", // 0xb2
        "[?]", // 0xb3
        "[?]", // 0xb4
        "[?]", // 0xb5
        "[?]", // 0xb6
        "[?]", // 0xb7
        "[?]", // 0xb8
        "[?]", // 0xb9
        "[?]", // 0xba
        "[?]", // 0xbb
        "[?]", // 0xbc
        "[?]", // 0xbd
        "[?]", // 0xbe
        "[?]", // 0xbf
        "[?]", // 0xc0
        "[?]", // 0xc1
        "[?]", // 0xc2
        "[?]", // 0xc3
        "[?]", // 0xc4
        "[?]", // 0xc5
        "[?]", // 0xc6
        "[?]", // 0xc7
        "[?]", // 0xc8
        "[?]", // 0xc9
        "[?]", // 0xca
        "[?]", // 0xcb
        "[?]", // 0xcc
        "[?]", // 0xcd
        "[?]", // 0xce
        "[?]", // 0xcf
        "[?]", // 0xd0
        "[?]", // 0xd1
        "[?]", // 0xd2
        "[?]", // 0xd3
        "[?]", // 0xd4
        "[?]", // 0xd5
        "[?]", // 0xd6
        "[?]", // 0xd7
        "[?]", // 0xd8
        "[?]", // 0xd9
        "[?]", // 0xda
        "[?]", // 0xdb
        "[?]", // 0xdc
        "[?]", // 0xdd
        "[?]", // 0xde
        "[?]", // 0xdf
        "[?]", // 0xe0
        "[?]", // 0xe1
        "[?]", // 0xe2
        "[?]", // 0xe3
        "[?]", // 0xe4
        "[?]", // 0xe5
        "[?]", // 0xe6
        "[?]", // 0xe7
        "[?]", // 0xe8
        "[?]", // 0xe9
        "[?]", // 0xea
        "[?]", // 0xeb
        "[?]", // 0xec
        "[?]", // 0xed
        "[?]", // 0xee
        "[?]", // 0xef
        "[?]", // 0xf0
        "[?]", // 0xf1
        "[?]", // 0xf2
        "[?]", // 0xf3
        "[?]", // 0xf4
        "[?]", // 0xf5
        "[?]", // 0xf6
        "[?]", // 0xf7
        "[?]", // 0xf8
        "[?]", // 0xf9
        "[?]", // 0xfa
        "[?]", // 0xfb
        "[?]", // 0xfc
        "[?]", // 0xfd
        "[?]" // 0xfe
    };
}
