/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+5Bxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X5b {

    public static final String[] map = new String[]{
        "Gui ", // 0x00
        "Deng ", // 0x01
        "Zhi ", // 0x02
        "Xu ", // 0x03
        "Yi ", // 0x04
        "Hua ", // 0x05
        "Xi ", // 0x06
        "Hui ", // 0x07
        "Rao ", // 0x08
        "Xi ", // 0x09
        "Yan ", // 0x0a
        "Chan ", // 0x0b
        "Jiao ", // 0x0c
        "Mei ", // 0x0d
        "Fan ", // 0x0e
        "Fan ", // 0x0f
        "Xian ", // 0x10
        "Yi ", // 0x11
        "Wei ", // 0x12
        "Jiao ", // 0x13
        "Fu ", // 0x14
        "Shi ", // 0x15
        "Bi ", // 0x16
        "Shan ", // 0x17
        "Sui ", // 0x18
        "Qiang ", // 0x19
        "Lian ", // 0x1a
        "Huan ", // 0x1b
        "Xin ", // 0x1c
        "Niao ", // 0x1d
        "Dong ", // 0x1e
        "Yi ", // 0x1f
        "Can ", // 0x20
        "Ai ", // 0x21
        "Niang ", // 0x22
        "Neng ", // 0x23
        "Ma ", // 0x24
        "Tiao ", // 0x25
        "Chou ", // 0x26
        "Jin ", // 0x27
        "Ci ", // 0x28
        "Yu ", // 0x29
        "Pin ", // 0x2a
        "Yong ", // 0x2b
        "Xu ", // 0x2c
        "Nai ", // 0x2d
        "Yan ", // 0x2e
        "Tai ", // 0x2f
        "Ying ", // 0x30
        "Can ", // 0x31
        "Niao ", // 0x32
        "Wo ", // 0x33
        "Ying ", // 0x34
        "Mian ", // 0x35
        "Kaka ", // 0x36
        "Ma ", // 0x37
        "Shen ", // 0x38
        "Xing ", // 0x39
        "Ni ", // 0x3a
        "Du ", // 0x3b
        "Liu ", // 0x3c
        "Yuan ", // 0x3d
        "Lan ", // 0x3e
        "Yan ", // 0x3f
        "Shuang ", // 0x40
        "Ling ", // 0x41
        "Jiao ", // 0x42
        "Niang ", // 0x43
        "Lan ", // 0x44
        "Xian ", // 0x45
        "Ying ", // 0x46
        "Shuang ", // 0x47
        "Shuai ", // 0x48
        "Quan ", // 0x49
        "Mi ", // 0x4a
        "Li ", // 0x4b
        "Luan ", // 0x4c
        "Yan ", // 0x4d
        "Zhu ", // 0x4e
        "Lan ", // 0x4f
        "Zi ", // 0x50
        "Jie ", // 0x51
        "Jue ", // 0x52
        "Jue ", // 0x53
        "Kong ", // 0x54
        "Yun ", // 0x55
        "Zi ", // 0x56
        "Zi ", // 0x57
        "Cun ", // 0x58
        "Sun ", // 0x59
        "Fu ", // 0x5a
        "Bei ", // 0x5b
        "Zi ", // 0x5c
        "Xiao ", // 0x5d
        "Xin ", // 0x5e
        "Meng ", // 0x5f
        "Si ", // 0x60
        "Tai ", // 0x61
        "Bao ", // 0x62
        "Ji ", // 0x63
        "Gu ", // 0x64
        "Nu ", // 0x65
        "Xue ", // 0x66
        "[?] ", // 0x67
        "Zhuan ", // 0x68
        "Hai ", // 0x69
        "Luan ", // 0x6a
        "Sun ", // 0x6b
        "Huai ", // 0x6c
        "Mie ", // 0x6d
        "Cong ", // 0x6e
        "Qian ", // 0x6f
        "Shu ", // 0x70
        "Chan ", // 0x71
        "Ya ", // 0x72
        "Zi ", // 0x73
        "Ni ", // 0x74
        "Fu ", // 0x75
        "Zi ", // 0x76
        "Li ", // 0x77
        "Xue ", // 0x78
        "Bo ", // 0x79
        "Ru ", // 0x7a
        "Lai ", // 0x7b
        "Nie ", // 0x7c
        "Nie ", // 0x7d
        "Ying ", // 0x7e
        "Luan ", // 0x7f
        "Mian ", // 0x80
        "Zhu ", // 0x81
        "Rong ", // 0x82
        "Ta ", // 0x83
        "Gui ", // 0x84
        "Zhai ", // 0x85
        "Qiong ", // 0x86
        "Yu ", // 0x87
        "Shou ", // 0x88
        "An ", // 0x89
        "Tu ", // 0x8a
        "Song ", // 0x8b
        "Wan ", // 0x8c
        "Rou ", // 0x8d
        "Yao ", // 0x8e
        "Hong ", // 0x8f
        "Yi ", // 0x90
        "Jing ", // 0x91
        "Zhun ", // 0x92
        "Mi ", // 0x93
        "Zhu ", // 0x94
        "Dang ", // 0x95
        "Hong ", // 0x96
        "Zong ", // 0x97
        "Guan ", // 0x98
        "Zhou ", // 0x99
        "Ding ", // 0x9a
        "Wan ", // 0x9b
        "Yi ", // 0x9c
        "Bao ", // 0x9d
        "Shi ", // 0x9e
        "Shi ", // 0x9f
        "Chong ", // 0xa0
        "Shen ", // 0xa1
        "Ke ", // 0xa2
        "Xuan ", // 0xa3
        "Shi ", // 0xa4
        "You ", // 0xa5
        "Huan ", // 0xa6
        "Yi ", // 0xa7
        "Tiao ", // 0xa8
        "Shi ", // 0xa9
        "Xian ", // 0xaa
        "Gong ", // 0xab
        "Cheng ", // 0xac
        "Qun ", // 0xad
        "Gong ", // 0xae
        "Xiao ", // 0xaf
        "Zai ", // 0xb0
        "Zha ", // 0xb1
        "Bao ", // 0xb2
        "Hai ", // 0xb3
        "Yan ", // 0xb4
        "Xiao ", // 0xb5
        "Jia ", // 0xb6
        "Shen ", // 0xb7
        "Chen ", // 0xb8
        "Rong ", // 0xb9
        "Huang ", // 0xba
        "Mi ", // 0xbb
        "Kou ", // 0xbc
        "Kuan ", // 0xbd
        "Bin ", // 0xbe
        "Su ", // 0xbf
        "Cai ", // 0xc0
        "Zan ", // 0xc1
        "Ji ", // 0xc2
        "Yuan ", // 0xc3
        "Ji ", // 0xc4
        "Yin ", // 0xc5
        "Mi ", // 0xc6
        "Kou ", // 0xc7
        "Qing ", // 0xc8
        "Que ", // 0xc9
        "Zhen ", // 0xca
        "Jian ", // 0xcb
        "Fu ", // 0xcc
        "Ning ", // 0xcd
        "Bing ", // 0xce
        "Huan ", // 0xcf
        "Mei ", // 0xd0
        "Qin ", // 0xd1
        "Han ", // 0xd2
        "Yu ", // 0xd3
        "Shi ", // 0xd4
        "Ning ", // 0xd5
        "Qin ", // 0xd6
        "Ning ", // 0xd7
        "Zhi ", // 0xd8
        "Yu ", // 0xd9
        "Bao ", // 0xda
        "Kuan ", // 0xdb
        "Ning ", // 0xdc
        "Qin ", // 0xdd
        "Mo ", // 0xde
        "Cha ", // 0xdf
        "Ju ", // 0xe0
        "Gua ", // 0xe1
        "Qin ", // 0xe2
        "Hu ", // 0xe3
        "Wu ", // 0xe4
        "Liao ", // 0xe5
        "Shi ", // 0xe6
        "Zhu ", // 0xe7
        "Zhai ", // 0xe8
        "Shen ", // 0xe9
        "Wei ", // 0xea
        "Xie ", // 0xeb
        "Kuan ", // 0xec
        "Hui ", // 0xed
        "Liao ", // 0xee
        "Jun ", // 0xef
        "Huan ", // 0xf0
        "Yi ", // 0xf1
        "Yi ", // 0xf2
        "Bao ", // 0xf3
        "Qin ", // 0xf4
        "Chong ", // 0xf5
        "Bao ", // 0xf6
        "Feng ", // 0xf7
        "Cun ", // 0xf8
        "Dui ", // 0xf9
        "Si ", // 0xfa
        "Xun ", // 0xfb
        "Dao ", // 0xfc
        "Lu ", // 0xfd
        "Dui ", // 0xfe
        "Shou " // 0xff
    };
}
