/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+7Cxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X7c {

    public static final String[] map = new String[]{
        "Ze ", // 0x00
        "Xi ", // 0x01
        "Guo ", // 0x02
        "Yi ", // 0x03
        "Hu ", // 0x04
        "Chan ", // 0x05
        "Kou ", // 0x06
        "Cu ", // 0x07
        "Ping ", // 0x08
        "Chou ", // 0x09
        "Ji ", // 0x0a
        "Gui ", // 0x0b
        "Su ", // 0x0c
        "Lou ", // 0x0d
        "Zha ", // 0x0e
        "Lu ", // 0x0f
        "Nian ", // 0x10
        "Suo ", // 0x11
        "Cuan ", // 0x12
        "Sasara ", // 0x13
        "Suo ", // 0x14
        "Le ", // 0x15
        "Duan ", // 0x16
        "Yana ", // 0x17
        "Xiao ", // 0x18
        "Bo ", // 0x19
        "Mi ", // 0x1a
        "Si ", // 0x1b
        "Dang ", // 0x1c
        "Liao ", // 0x1d
        "Dan ", // 0x1e
        "Dian ", // 0x1f
        "Fu ", // 0x20
        "Jian ", // 0x21
        "Min ", // 0x22
        "Kui ", // 0x23
        "Dai ", // 0x24
        "Qiao ", // 0x25
        "Deng ", // 0x26
        "Huang ", // 0x27
        "Sun ", // 0x28
        "Lao ", // 0x29
        "Zan ", // 0x2a
        "Xiao ", // 0x2b
        "Du ", // 0x2c
        "Shi ", // 0x2d
        "Zan ", // 0x2e
        "[?] ", // 0x2f
        "Pai ", // 0x30
        "Hata ", // 0x31
        "Pai ", // 0x32
        "Gan ", // 0x33
        "Ju ", // 0x34
        "Du ", // 0x35
        "Lu ", // 0x36
        "Yan ", // 0x37
        "Bo ", // 0x38
        "Dang ", // 0x39
        "Sai ", // 0x3a
        "Ke ", // 0x3b
        "Long ", // 0x3c
        "Qian ", // 0x3d
        "Lian ", // 0x3e
        "Bo ", // 0x3f
        "Zhou ", // 0x40
        "Lai ", // 0x41
        "[?] ", // 0x42
        "Lan ", // 0x43
        "Kui ", // 0x44
        "Yu ", // 0x45
        "Yue ", // 0x46
        "Hao ", // 0x47
        "Zhen ", // 0x48
        "Tai ", // 0x49
        "Ti ", // 0x4a
        "Mi ", // 0x4b
        "Chou ", // 0x4c
        "Ji ", // 0x4d
        "[?] ", // 0x4e
        "Hata ", // 0x4f
        "Teng ", // 0x50
        "Zhuan ", // 0x51
        "Zhou ", // 0x52
        "Fan ", // 0x53
        "Sou ", // 0x54
        "Zhou ", // 0x55
        "Kuji ", // 0x56
        "Zhuo ", // 0x57
        "Teng ", // 0x58
        "Lu ", // 0x59
        "Lu ", // 0x5a
        "Jian ", // 0x5b
        "Tuo ", // 0x5c
        "Ying ", // 0x5d
        "Yu ", // 0x5e
        "Lai ", // 0x5f
        "Long ", // 0x60
        "Shinshi ", // 0x61
        "Lian ", // 0x62
        "Lan ", // 0x63
        "Qian ", // 0x64
        "Yue ", // 0x65
        "Zhong ", // 0x66
        "Qu ", // 0x67
        "Lian ", // 0x68
        "Bian ", // 0x69
        "Duan ", // 0x6a
        "Zuan ", // 0x6b
        "Li ", // 0x6c
        "Si ", // 0x6d
        "Luo ", // 0x6e
        "Ying ", // 0x6f
        "Yue ", // 0x70
        "Zhuo ", // 0x71
        "Xu ", // 0x72
        "Mi ", // 0x73
        "Di ", // 0x74
        "Fan ", // 0x75
        "Shen ", // 0x76
        "Zhe ", // 0x77
        "Shen ", // 0x78
        "Nu ", // 0x79
        "Xie ", // 0x7a
        "Lei ", // 0x7b
        "Xian ", // 0x7c
        "Zi ", // 0x7d
        "Ni ", // 0x7e
        "Cun ", // 0x7f
        "[?] ", // 0x80
        "Qian ", // 0x81
        "Kume ", // 0x82
        "Bi ", // 0x83
        "Ban ", // 0x84
        "Wu ", // 0x85
        "Sha ", // 0x86
        "Kang ", // 0x87
        "Rou ", // 0x88
        "Fen ", // 0x89
        "Bi ", // 0x8a
        "Cui ", // 0x8b
        "[?] ", // 0x8c
        "Li ", // 0x8d
        "Chi ", // 0x8e
        "Nukamiso ", // 0x8f
        "Ro ", // 0x90
        "Ba ", // 0x91
        "Li ", // 0x92
        "Gan ", // 0x93
        "Ju ", // 0x94
        "Po ", // 0x95
        "Mo ", // 0x96
        "Cu ", // 0x97
        "Nian ", // 0x98
        "Zhou ", // 0x99
        "Li ", // 0x9a
        "Su ", // 0x9b
        "Tiao ", // 0x9c
        "Li ", // 0x9d
        "Qi ", // 0x9e
        "Su ", // 0x9f
        "Hong ", // 0xa0
        "Tong ", // 0xa1
        "Zi ", // 0xa2
        "Ce ", // 0xa3
        "Yue ", // 0xa4
        "Zhou ", // 0xa5
        "Lin ", // 0xa6
        "Zhuang ", // 0xa7
        "Bai ", // 0xa8
        "[?] ", // 0xa9
        "Fen ", // 0xaa
        "Ji ", // 0xab
        "[?] ", // 0xac
        "Sukumo ", // 0xad
        "Liang ", // 0xae
        "Xian ", // 0xaf
        "Fu ", // 0xb0
        "Liang ", // 0xb1
        "Can ", // 0xb2
        "Geng ", // 0xb3
        "Li ", // 0xb4
        "Yue ", // 0xb5
        "Lu ", // 0xb6
        "Ju ", // 0xb7
        "Qi ", // 0xb8
        "Cui ", // 0xb9
        "Bai ", // 0xba
        "Zhang ", // 0xbb
        "Lin ", // 0xbc
        "Zong ", // 0xbd
        "Jing ", // 0xbe
        "Guo ", // 0xbf
        "Kouji ", // 0xc0
        "San ", // 0xc1
        "San ", // 0xc2
        "Tang ", // 0xc3
        "Bian ", // 0xc4
        "Rou ", // 0xc5
        "Mian ", // 0xc6
        "Hou ", // 0xc7
        "Xu ", // 0xc8
        "Zong ", // 0xc9
        "Hu ", // 0xca
        "Jian ", // 0xcb
        "Zan ", // 0xcc
        "Ci ", // 0xcd
        "Li ", // 0xce
        "Xie ", // 0xcf
        "Fu ", // 0xd0
        "Ni ", // 0xd1
        "Bei ", // 0xd2
        "Gu ", // 0xd3
        "Xiu ", // 0xd4
        "Gao ", // 0xd5
        "Tang ", // 0xd6
        "Qiu ", // 0xd7
        "Sukumo ", // 0xd8
        "Cao ", // 0xd9
        "Zhuang ", // 0xda
        "Tang ", // 0xdb
        "Mi ", // 0xdc
        "San ", // 0xdd
        "Fen ", // 0xde
        "Zao ", // 0xdf
        "Kang ", // 0xe0
        "Jiang ", // 0xe1
        "Mo ", // 0xe2
        "San ", // 0xe3
        "San ", // 0xe4
        "Nuo ", // 0xe5
        "Xi ", // 0xe6
        "Liang ", // 0xe7
        "Jiang ", // 0xe8
        "Kuai ", // 0xe9
        "Bo ", // 0xea
        "Huan ", // 0xeb
        "[?] ", // 0xec
        "Zong ", // 0xed
        "Xian ", // 0xee
        "Nuo ", // 0xef
        "Tuan ", // 0xf0
        "Nie ", // 0xf1
        "Li ", // 0xf2
        "Zuo ", // 0xf3
        "Di ", // 0xf4
        "Nie ", // 0xf5
        "Tiao ", // 0xf6
        "Lan ", // 0xf7
        "Mi ", // 0xf8
        "Jiao ", // 0xf9
        "Jiu ", // 0xfa
        "Xi ", // 0xfb
        "Gong ", // 0xfc
        "Zheng ", // 0xfd
        "Jiu ", // 0xfe
        "You " // 0xff
    };
}
