/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+7Dxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X7d {

    public static final String[] map = new String[]{
        "Ji ", // 0x00
        "Cha ", // 0x01
        "Zhou ", // 0x02
        "Xun ", // 0x03
        "Yue ", // 0x04
        "Hong ", // 0x05
        "Yu ", // 0x06
        "He ", // 0x07
        "Wan ", // 0x08
        "Ren ", // 0x09
        "Wen ", // 0x0a
        "Wen ", // 0x0b
        "Qiu ", // 0x0c
        "Na ", // 0x0d
        "Zi ", // 0x0e
        "Tou ", // 0x0f
        "Niu ", // 0x10
        "Fou ", // 0x11
        "Jie ", // 0x12
        "Shu ", // 0x13
        "Chun ", // 0x14
        "Pi ", // 0x15
        "Yin ", // 0x16
        "Sha ", // 0x17
        "Hong ", // 0x18
        "Zhi ", // 0x19
        "Ji ", // 0x1a
        "Fen ", // 0x1b
        "Yun ", // 0x1c
        "Ren ", // 0x1d
        "Dan ", // 0x1e
        "Jin ", // 0x1f
        "Su ", // 0x20
        "Fang ", // 0x21
        "Suo ", // 0x22
        "Cui ", // 0x23
        "Jiu ", // 0x24
        "Zha ", // 0x25
        "Kinu ", // 0x26
        "Jin ", // 0x27
        "Fu ", // 0x28
        "Zhi ", // 0x29
        "Ci ", // 0x2a
        "Zi ", // 0x2b
        "Chou ", // 0x2c
        "Hong ", // 0x2d
        "Zha ", // 0x2e
        "Lei ", // 0x2f
        "Xi ", // 0x30
        "Fu ", // 0x31
        "Xie ", // 0x32
        "Shen ", // 0x33
        "Bei ", // 0x34
        "Zhu ", // 0x35
        "Qu ", // 0x36
        "Ling ", // 0x37
        "Zhu ", // 0x38
        "Shao ", // 0x39
        "Gan ", // 0x3a
        "Yang ", // 0x3b
        "Fu ", // 0x3c
        "Tuo ", // 0x3d
        "Zhen ", // 0x3e
        "Dai ", // 0x3f
        "Zhuo ", // 0x40
        "Shi ", // 0x41
        "Zhong ", // 0x42
        "Xian ", // 0x43
        "Zu ", // 0x44
        "Jiong ", // 0x45
        "Ban ", // 0x46
        "Ju ", // 0x47
        "Mo ", // 0x48
        "Shu ", // 0x49
        "Zui ", // 0x4a
        "Wata ", // 0x4b
        "Jing ", // 0x4c
        "Ren ", // 0x4d
        "Heng ", // 0x4e
        "Xie ", // 0x4f
        "Jie ", // 0x50
        "Zhu ", // 0x51
        "Chou ", // 0x52
        "Gua ", // 0x53
        "Bai ", // 0x54
        "Jue ", // 0x55
        "Kuang ", // 0x56
        "Hu ", // 0x57
        "Ci ", // 0x58
        "Geng ", // 0x59
        "Geng ", // 0x5a
        "Tao ", // 0x5b
        "Xie ", // 0x5c
        "Ku ", // 0x5d
        "Jiao ", // 0x5e
        "Quan ", // 0x5f
        "Gai ", // 0x60
        "Luo ", // 0x61
        "Xuan ", // 0x62
        "Bing ", // 0x63
        "Xian ", // 0x64
        "Fu ", // 0x65
        "Gei ", // 0x66
        "Tong ", // 0x67
        "Rong ", // 0x68
        "Tiao ", // 0x69
        "Yin ", // 0x6a
        "Lei ", // 0x6b
        "Xie ", // 0x6c
        "Quan ", // 0x6d
        "Xu ", // 0x6e
        "Lun ", // 0x6f
        "Die ", // 0x70
        "Tong ", // 0x71
        "Si ", // 0x72
        "Jiang ", // 0x73
        "Xiang ", // 0x74
        "Hui ", // 0x75
        "Jue ", // 0x76
        "Zhi ", // 0x77
        "Jian ", // 0x78
        "Juan ", // 0x79
        "Chi ", // 0x7a
        "Mian ", // 0x7b
        "Zhen ", // 0x7c
        "Lu ", // 0x7d
        "Cheng ", // 0x7e
        "Qiu ", // 0x7f
        "Shu ", // 0x80
        "Bang ", // 0x81
        "Tong ", // 0x82
        "Xiao ", // 0x83
        "Wan ", // 0x84
        "Qin ", // 0x85
        "Geng ", // 0x86
        "Xiu ", // 0x87
        "Ti ", // 0x88
        "Xiu ", // 0x89
        "Xie ", // 0x8a
        "Hong ", // 0x8b
        "Xi ", // 0x8c
        "Fu ", // 0x8d
        "Ting ", // 0x8e
        "Sui ", // 0x8f
        "Dui ", // 0x90
        "Kun ", // 0x91
        "Fu ", // 0x92
        "Jing ", // 0x93
        "Hu ", // 0x94
        "Zhi ", // 0x95
        "Yan ", // 0x96
        "Jiong ", // 0x97
        "Feng ", // 0x98
        "Ji ", // 0x99
        "Sok ", // 0x9a
        "Kase ", // 0x9b
        "Zong ", // 0x9c
        "Lin ", // 0x9d
        "Duo ", // 0x9e
        "Li ", // 0x9f
        "Lu ", // 0xa0
        "Liang ", // 0xa1
        "Chou ", // 0xa2
        "Quan ", // 0xa3
        "Shao ", // 0xa4
        "Qi ", // 0xa5
        "Qi ", // 0xa6
        "Zhun ", // 0xa7
        "Qi ", // 0xa8
        "Wan ", // 0xa9
        "Qian ", // 0xaa
        "Xian ", // 0xab
        "Shou ", // 0xac
        "Wei ", // 0xad
        "Qi ", // 0xae
        "Tao ", // 0xaf
        "Wan ", // 0xb0
        "Gang ", // 0xb1
        "Wang ", // 0xb2
        "Beng ", // 0xb3
        "Zhui ", // 0xb4
        "Cai ", // 0xb5
        "Guo ", // 0xb6
        "Cui ", // 0xb7
        "Lun ", // 0xb8
        "Liu ", // 0xb9
        "Qi ", // 0xba
        "Zhan ", // 0xbb
        "Bei ", // 0xbc
        "Chuo ", // 0xbd
        "Ling ", // 0xbe
        "Mian ", // 0xbf
        "Qi ", // 0xc0
        "Qie ", // 0xc1
        "Tan ", // 0xc2
        "Zong ", // 0xc3
        "Gun ", // 0xc4
        "Zou ", // 0xc5
        "Yi ", // 0xc6
        "Zi ", // 0xc7
        "Xing ", // 0xc8
        "Liang ", // 0xc9
        "Jin ", // 0xca
        "Fei ", // 0xcb
        "Rui ", // 0xcc
        "Min ", // 0xcd
        "Yu ", // 0xce
        "Zong ", // 0xcf
        "Fan ", // 0xd0
        "Lu ", // 0xd1
        "Xu ", // 0xd2
        "Yingl ", // 0xd3
        "Zhang ", // 0xd4
        "Kasuri ", // 0xd5
        "Xu ", // 0xd6
        "Xiang ", // 0xd7
        "Jian ", // 0xd8
        "Ke ", // 0xd9
        "Xian ", // 0xda
        "Ruan ", // 0xdb
        "Mian ", // 0xdc
        "Qi ", // 0xdd
        "Duan ", // 0xde
        "Zhong ", // 0xdf
        "Di ", // 0xe0
        "Min ", // 0xe1
        "Miao ", // 0xe2
        "Yuan ", // 0xe3
        "Xie ", // 0xe4
        "Bao ", // 0xe5
        "Si ", // 0xe6
        "Qiu ", // 0xe7
        "Bian ", // 0xe8
        "Huan ", // 0xe9
        "Geng ", // 0xea
        "Cong ", // 0xeb
        "Mian ", // 0xec
        "Wei ", // 0xed
        "Fu ", // 0xee
        "Wei ", // 0xef
        "Yu ", // 0xf0
        "Gou ", // 0xf1
        "Miao ", // 0xf2
        "Xie ", // 0xf3
        "Lian ", // 0xf4
        "Zong ", // 0xf5
        "Bian ", // 0xf6
        "Yun ", // 0xf7
        "Yin ", // 0xf8
        "Ti ", // 0xf9
        "Gua ", // 0xfa
        "Zhi ", // 0xfb
        "Yun ", // 0xfc
        "Cheng ", // 0xfd
        "Chan ", // 0xfe
        "Dai " // 0xff
    };
}
