/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+9Fxx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class X9f {

    public static final String[] map = new String[]{
        "Cu ", // 0x00
        "Qu ", // 0x01
        "Chao ", // 0x02
        "Wa ", // 0x03
        "Zhu ", // 0x04
        "Zhi ", // 0x05
        "Mang ", // 0x06
        "Ao ", // 0x07
        "Bie ", // 0x08
        "Tuo ", // 0x09
        "Bi ", // 0x0a
        "Yuan ", // 0x0b
        "Chao ", // 0x0c
        "Tuo ", // 0x0d
        "Ding ", // 0x0e
        "Mi ", // 0x0f
        "Nai ", // 0x10
        "Ding ", // 0x11
        "Zi ", // 0x12
        "Gu ", // 0x13
        "Gu ", // 0x14
        "Dong ", // 0x15
        "Fen ", // 0x16
        "Tao ", // 0x17
        "Yuan ", // 0x18
        "Pi ", // 0x19
        "Chang ", // 0x1a
        "Gao ", // 0x1b
        "Qi ", // 0x1c
        "Yuan ", // 0x1d
        "Tang ", // 0x1e
        "Teng ", // 0x1f
        "Shu ", // 0x20
        "Shu ", // 0x21
        "Fen ", // 0x22
        "Fei ", // 0x23
        "Wen ", // 0x24
        "Ba ", // 0x25
        "Diao ", // 0x26
        "Tuo ", // 0x27
        "Tong ", // 0x28
        "Qu ", // 0x29
        "Sheng ", // 0x2a
        "Shi ", // 0x2b
        "You ", // 0x2c
        "Shi ", // 0x2d
        "Ting ", // 0x2e
        "Wu ", // 0x2f
        "Nian ", // 0x30
        "Jing ", // 0x31
        "Hun ", // 0x32
        "Ju ", // 0x33
        "Yan ", // 0x34
        "Tu ", // 0x35
        "Ti ", // 0x36
        "Xi ", // 0x37
        "Xian ", // 0x38
        "Yan ", // 0x39
        "Lei ", // 0x3a
        "Bi ", // 0x3b
        "Yao ", // 0x3c
        "Qiu ", // 0x3d
        "Han ", // 0x3e
        "Wu ", // 0x3f
        "Wu ", // 0x40
        "Hou ", // 0x41
        "Xi ", // 0x42
        "Ge ", // 0x43
        "Zha ", // 0x44
        "Xiu ", // 0x45
        "Weng ", // 0x46
        "Zha ", // 0x47
        "Nong ", // 0x48
        "Nang ", // 0x49
        "Qi ", // 0x4a
        "Zhai ", // 0x4b
        "Ji ", // 0x4c
        "Zi ", // 0x4d
        "Ji ", // 0x4e
        "Ji ", // 0x4f
        "Qi ", // 0x50
        "Ji ", // 0x51
        "Chi ", // 0x52
        "Chen ", // 0x53
        "Chen ", // 0x54
        "He ", // 0x55
        "Ya ", // 0x56
        "Ken ", // 0x57
        "Xie ", // 0x58
        "Pao ", // 0x59
        "Cuo ", // 0x5a
        "Shi ", // 0x5b
        "Zi ", // 0x5c
        "Chi ", // 0x5d
        "Nian ", // 0x5e
        "Ju ", // 0x5f
        "Tiao ", // 0x60
        "Ling ", // 0x61
        "Ling ", // 0x62
        "Chu ", // 0x63
        "Quan ", // 0x64
        "Xie ", // 0x65
        "Ken ", // 0x66
        "Nie ", // 0x67
        "Jiu ", // 0x68
        "Yao ", // 0x69
        "Chuo ", // 0x6a
        "Kun ", // 0x6b
        "Yu ", // 0x6c
        "Chu ", // 0x6d
        "Yi ", // 0x6e
        "Ni ", // 0x6f
        "Cuo ", // 0x70
        "Zou ", // 0x71
        "Qu ", // 0x72
        "Nen ", // 0x73
        "Xian ", // 0x74
        "Ou ", // 0x75
        "E ", // 0x76
        "Wo ", // 0x77
        "Yi ", // 0x78
        "Chuo ", // 0x79
        "Zou ", // 0x7a
        "Dian ", // 0x7b
        "Chu ", // 0x7c
        "Jin ", // 0x7d
        "Ya ", // 0x7e
        "Chi ", // 0x7f
        "Chen ", // 0x80
        "He ", // 0x81
        "Ken ", // 0x82
        "Ju ", // 0x83
        "Ling ", // 0x84
        "Pao ", // 0x85
        "Tiao ", // 0x86
        "Zi ", // 0x87
        "Ken ", // 0x88
        "Yu ", // 0x89
        "Chuo ", // 0x8a
        "Qu ", // 0x8b
        "Wo ", // 0x8c
        "Long ", // 0x8d
        "Pang ", // 0x8e
        "Gong ", // 0x8f
        "Pang ", // 0x90
        "Yan ", // 0x91
        "Long ", // 0x92
        "Long ", // 0x93
        "Gong ", // 0x94
        "Kan ", // 0x95
        "Ta ", // 0x96
        "Ling ", // 0x97
        "Ta ", // 0x98
        "Long ", // 0x99
        "Gong ", // 0x9a
        "Kan ", // 0x9b
        "Gui ", // 0x9c
        "Qiu ", // 0x9d
        "Bie ", // 0x9e
        "Gui ", // 0x9f
        "Yue ", // 0xa0
        "Chui ", // 0xa1
        "He ", // 0xa2
        "Jue ", // 0xa3
        "Xie ", // 0xa4
        "Yu ", // 0xa5
        "[?]", // 0xa6
        "[?]", // 0xa7
        "[?]", // 0xa8
        "[?]", // 0xa9
        "[?]", // 0xaa
        "[?]", // 0xab
        "[?]", // 0xac
        "[?]", // 0xad
        "[?]", // 0xae
        "[?]", // 0xaf
        "[?]", // 0xb0
        "[?]", // 0xb1
        "[?]", // 0xb2
        "[?]", // 0xb3
        "[?]", // 0xb4
        "[?]", // 0xb5
        "[?]", // 0xb6
        "[?]", // 0xb7
        "[?]", // 0xb8
        "[?]", // 0xb9
        "[?]", // 0xba
        "[?]", // 0xbb
        "[?]", // 0xbc
        "[?]", // 0xbd
        "[?]", // 0xbe
        "[?]", // 0xbf
        "[?]", // 0xc0
        "[?]", // 0xc1
        "[?]", // 0xc2
        "[?]", // 0xc3
        "[?]", // 0xc4
        "[?]", // 0xc5
        "[?]", // 0xc6
        "[?]", // 0xc7
        "[?]", // 0xc8
        "[?]", // 0xc9
        "[?]", // 0xca
        "[?]", // 0xcb
        "[?]", // 0xcc
        "[?]", // 0xcd
        "[?]", // 0xce
        "[?]", // 0xcf
        "[?]", // 0xd0
        "[?]", // 0xd1
        "[?]", // 0xd2
        "[?]", // 0xd3
        "[?]", // 0xd4
        "[?]", // 0xd5
        "[?]", // 0xd6
        "[?]", // 0xd7
        "[?]", // 0xd8
        "[?]", // 0xd9
        "[?]", // 0xda
        "[?]", // 0xdb
        "[?]", // 0xdc
        "[?]", // 0xdd
        "[?]", // 0xde
        "[?]", // 0xdf
        "[?]", // 0xe0
        "[?]", // 0xe1
        "[?]", // 0xe2
        "[?]", // 0xe3
        "[?]", // 0xe4
        "[?]", // 0xe5
        "[?]", // 0xe6
        "[?]", // 0xe7
        "[?]", // 0xe8
        "[?]", // 0xe9
        "[?]", // 0xea
        "[?]", // 0xeb
        "[?]", // 0xec
        "[?]", // 0xed
        "[?]", // 0xee
        "[?]", // 0xef
        "[?]", // 0xf0
        "[?]", // 0xf1
        "[?]", // 0xf2
        "[?]", // 0xf3
        "[?]", // 0xf4
        "[?]", // 0xf5
        "[?]", // 0xf6
        "[?]", // 0xf7
        "[?]", // 0xf8
        "[?]", // 0xf9
        "[?]", // 0xfa
        "[?]", // 0xfb
        "[?]", // 0xfc
        "[?]", // 0xfd
        "[?]" // 0xfe
    };
}
