/*
 * Copyright (c) 2009, Giuseppe Cardone <ippatsuman@gmail.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of the author nor the names of the contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GIUSEPPE CARDONE ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GIUSEPPE CARDONE BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package net.sf.junidecode;

/**
 * Character map for Unicode characters with codepoint U+D2xx.
 * @author Giuseppe Cardone
 * @version 0.1
 */
class Xd2 {

    public static final String[] map = new String[]{
        "toels", // 0x00
        "toelt", // 0x01
        "toelp", // 0x02
        "toelh", // 0x03
        "toem", // 0x04
        "toeb", // 0x05
        "toebs", // 0x06
        "toes", // 0x07
        "toess", // 0x08
        "toeng", // 0x09
        "toej", // 0x0a
        "toec", // 0x0b
        "toek", // 0x0c
        "toet", // 0x0d
        "toep", // 0x0e
        "toeh", // 0x0f
        "tyo", // 0x10
        "tyog", // 0x11
        "tyogg", // 0x12
        "tyogs", // 0x13
        "tyon", // 0x14
        "tyonj", // 0x15
        "tyonh", // 0x16
        "tyod", // 0x17
        "tyol", // 0x18
        "tyolg", // 0x19
        "tyolm", // 0x1a
        "tyolb", // 0x1b
        "tyols", // 0x1c
        "tyolt", // 0x1d
        "tyolp", // 0x1e
        "tyolh", // 0x1f
        "tyom", // 0x20
        "tyob", // 0x21
        "tyobs", // 0x22
        "tyos", // 0x23
        "tyoss", // 0x24
        "tyong", // 0x25
        "tyoj", // 0x26
        "tyoc", // 0x27
        "tyok", // 0x28
        "tyot", // 0x29
        "tyop", // 0x2a
        "tyoh", // 0x2b
        "tu", // 0x2c
        "tug", // 0x2d
        "tugg", // 0x2e
        "tugs", // 0x2f
        "tun", // 0x30
        "tunj", // 0x31
        "tunh", // 0x32
        "tud", // 0x33
        "tul", // 0x34
        "tulg", // 0x35
        "tulm", // 0x36
        "tulb", // 0x37
        "tuls", // 0x38
        "tult", // 0x39
        "tulp", // 0x3a
        "tulh", // 0x3b
        "tum", // 0x3c
        "tub", // 0x3d
        "tubs", // 0x3e
        "tus", // 0x3f
        "tuss", // 0x40
        "tung", // 0x41
        "tuj", // 0x42
        "tuc", // 0x43
        "tuk", // 0x44
        "tut", // 0x45
        "tup", // 0x46
        "tuh", // 0x47
        "tweo", // 0x48
        "tweog", // 0x49
        "tweogg", // 0x4a
        "tweogs", // 0x4b
        "tweon", // 0x4c
        "tweonj", // 0x4d
        "tweonh", // 0x4e
        "tweod", // 0x4f
        "tweol", // 0x50
        "tweolg", // 0x51
        "tweolm", // 0x52
        "tweolb", // 0x53
        "tweols", // 0x54
        "tweolt", // 0x55
        "tweolp", // 0x56
        "tweolh", // 0x57
        "tweom", // 0x58
        "tweob", // 0x59
        "tweobs", // 0x5a
        "tweos", // 0x5b
        "tweoss", // 0x5c
        "tweong", // 0x5d
        "tweoj", // 0x5e
        "tweoc", // 0x5f
        "tweok", // 0x60
        "tweot", // 0x61
        "tweop", // 0x62
        "tweoh", // 0x63
        "twe", // 0x64
        "tweg", // 0x65
        "twegg", // 0x66
        "twegs", // 0x67
        "twen", // 0x68
        "twenj", // 0x69
        "twenh", // 0x6a
        "twed", // 0x6b
        "twel", // 0x6c
        "twelg", // 0x6d
        "twelm", // 0x6e
        "twelb", // 0x6f
        "twels", // 0x70
        "twelt", // 0x71
        "twelp", // 0x72
        "twelh", // 0x73
        "twem", // 0x74
        "tweb", // 0x75
        "twebs", // 0x76
        "twes", // 0x77
        "twess", // 0x78
        "tweng", // 0x79
        "twej", // 0x7a
        "twec", // 0x7b
        "twek", // 0x7c
        "twet", // 0x7d
        "twep", // 0x7e
        "tweh", // 0x7f
        "twi", // 0x80
        "twig", // 0x81
        "twigg", // 0x82
        "twigs", // 0x83
        "twin", // 0x84
        "twinj", // 0x85
        "twinh", // 0x86
        "twid", // 0x87
        "twil", // 0x88
        "twilg", // 0x89
        "twilm", // 0x8a
        "twilb", // 0x8b
        "twils", // 0x8c
        "twilt", // 0x8d
        "twilp", // 0x8e
        "twilh", // 0x8f
        "twim", // 0x90
        "twib", // 0x91
        "twibs", // 0x92
        "twis", // 0x93
        "twiss", // 0x94
        "twing", // 0x95
        "twij", // 0x96
        "twic", // 0x97
        "twik", // 0x98
        "twit", // 0x99
        "twip", // 0x9a
        "twih", // 0x9b
        "tyu", // 0x9c
        "tyug", // 0x9d
        "tyugg", // 0x9e
        "tyugs", // 0x9f
        "tyun", // 0xa0
        "tyunj", // 0xa1
        "tyunh", // 0xa2
        "tyud", // 0xa3
        "tyul", // 0xa4
        "tyulg", // 0xa5
        "tyulm", // 0xa6
        "tyulb", // 0xa7
        "tyuls", // 0xa8
        "tyult", // 0xa9
        "tyulp", // 0xaa
        "tyulh", // 0xab
        "tyum", // 0xac
        "tyub", // 0xad
        "tyubs", // 0xae
        "tyus", // 0xaf
        "tyuss", // 0xb0
        "tyung", // 0xb1
        "tyuj", // 0xb2
        "tyuc", // 0xb3
        "tyuk", // 0xb4
        "tyut", // 0xb5
        "tyup", // 0xb6
        "tyuh", // 0xb7
        "teu", // 0xb8
        "teug", // 0xb9
        "teugg", // 0xba
        "teugs", // 0xbb
        "teun", // 0xbc
        "teunj", // 0xbd
        "teunh", // 0xbe
        "teud", // 0xbf
        "teul", // 0xc0
        "teulg", // 0xc1
        "teulm", // 0xc2
        "teulb", // 0xc3
        "teuls", // 0xc4
        "teult", // 0xc5
        "teulp", // 0xc6
        "teulh", // 0xc7
        "teum", // 0xc8
        "teub", // 0xc9
        "teubs", // 0xca
        "teus", // 0xcb
        "teuss", // 0xcc
        "teung", // 0xcd
        "teuj", // 0xce
        "teuc", // 0xcf
        "teuk", // 0xd0
        "teut", // 0xd1
        "teup", // 0xd2
        "teuh", // 0xd3
        "tyi", // 0xd4
        "tyig", // 0xd5
        "tyigg", // 0xd6
        "tyigs", // 0xd7
        "tyin", // 0xd8
        "tyinj", // 0xd9
        "tyinh", // 0xda
        "tyid", // 0xdb
        "tyil", // 0xdc
        "tyilg", // 0xdd
        "tyilm", // 0xde
        "tyilb", // 0xdf
        "tyils", // 0xe0
        "tyilt", // 0xe1
        "tyilp", // 0xe2
        "tyilh", // 0xe3
        "tyim", // 0xe4
        "tyib", // 0xe5
        "tyibs", // 0xe6
        "tyis", // 0xe7
        "tyiss", // 0xe8
        "tying", // 0xe9
        "tyij", // 0xea
        "tyic", // 0xeb
        "tyik", // 0xec
        "tyit", // 0xed
        "tyip", // 0xee
        "tyih", // 0xef
        "ti", // 0xf0
        "tig", // 0xf1
        "tigg", // 0xf2
        "tigs", // 0xf3
        "tin", // 0xf4
        "tinj", // 0xf5
        "tinh", // 0xf6
        "tid", // 0xf7
        "til", // 0xf8
        "tilg", // 0xf9
        "tilm", // 0xfa
        "tilb", // 0xfb
        "tils", // 0xfc
        "tilt", // 0xfd
        "tilp", // 0xfe
        "tilh" // 0xff
    };
}
