/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.dependencies;

import com.mycila.maven.plugin.license.dependencies.ArtifactLicensePolicyEnforcer;
import com.mycila.maven.plugin.license.dependencies.DefaultLicensePolicyEnforcer;
import com.mycila.maven.plugin.license.dependencies.LicenseMap;
import com.mycila.maven.plugin.license.dependencies.LicenseNameLicensePolicyEnforcer;
import com.mycila.maven.plugin.license.dependencies.LicensePolicy;
import com.mycila.maven.plugin.license.dependencies.LicensePolicyEnforcer;
import com.mycila.maven.plugin.license.dependencies.LicensePolicyEnforcerResult;
import com.mycila.maven.plugin.license.dependencies.LicenseURLLicensePolicyEnforcer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;

public class AggregateLicensePolicyEnforcer {
    private final Set<LicensePolicy> policies;
    private LicensePolicyEnforcer defaultPolicy;
    private Set<LicensePolicyEnforcer> enforcers;

    public AggregateLicensePolicyEnforcer(Set<LicensePolicy> policies) {
        this.policies = policies;
        this.defaultPolicy = new DefaultLicensePolicyEnforcer();
        this.enforcers = policies.stream().map(AggregateLicensePolicyEnforcer::initPolicyEnforcer).collect(Collectors.toSet());
    }

    private static LicensePolicyEnforcer<?> initPolicyEnforcer(LicensePolicy policy) {
        switch (policy.getType()) {
            case LICENSE_NAME: {
                return new LicenseNameLicensePolicyEnforcer(policy);
            }
            case ARTIFACT_PATTERN: {
                return new ArtifactLicensePolicyEnforcer(policy);
            }
            case LICENSE_URL: {
                return new LicenseURLLicensePolicyEnforcer(policy);
            }
        }
        return new DefaultLicensePolicyEnforcer();
    }

    private Set<LicensePolicyEnforcer> getEnforcers(LicensePolicy.Rule rule) {
        return this.enforcers.stream().filter(e -> e.getPolicy().getRule() == rule).collect(Collectors.toSet());
    }

    private Map<Artifact, LicensePolicyEnforcerResult> apply(License license, Set<Artifact> artifacts, LicensePolicyEnforcer enforcer) {
        HashMap results = new HashMap();
        LicensePolicy.Rule filter = enforcer.getPolicy().getRule();
        artifacts.forEach(artifact -> {
            LicensePolicy.Rule ruling = LicensePolicy.Rule.DENY;
            if (enforcer.getType() == License.class) {
                ruling = LicensePolicy.Rule.valueOf(enforcer.apply(license));
            } else if (enforcer.getType() == Artifact.class) {
                ruling = LicensePolicy.Rule.valueOf(enforcer.apply(artifact));
            }
            results.put(artifact, new LicensePolicyEnforcerResult(enforcer.getPolicy(), license, (Artifact)artifact, ruling));
        });
        return results.entrySet().stream().filter(result -> filter.equals((Object)((LicensePolicyEnforcerResult)result.getValue()).getRuling())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<Artifact, LicensePolicyEnforcerResult> apply(Map<License, Set<Artifact>> licenseMap, LicensePolicyEnforcer enforcer) {
        HashMap<Artifact, LicensePolicyEnforcerResult> results = new HashMap<Artifact, LicensePolicyEnforcerResult>();
        licenseMap.forEach((license, artifactSet) -> results.putAll(this.apply((License)license, (Set<Artifact>)artifactSet, enforcer)));
        return results;
    }

    public Map<Artifact, LicensePolicyEnforcerResult> apply(Map<License, Set<Artifact>> licenseMap) {
        HashMap<Artifact, LicensePolicyEnforcerResult> results = new HashMap<Artifact, LicensePolicyEnforcerResult>();
        licenseMap.entrySet().stream().forEach(entry -> {
            License license = (License)entry.getKey();
            ((Set)entry.getValue()).forEach(artifact -> results.putIfAbsent((Artifact)artifact, new LicensePolicyEnforcerResult(this.defaultPolicy.getPolicy(), license, (Artifact)artifact, LicensePolicy.Rule.valueOf(this.defaultPolicy.apply(artifact)))));
        });
        this.getEnforcers(LicensePolicy.Rule.APPROVE).forEach(enforcer -> results.putAll(this.apply(licenseMap, (LicensePolicyEnforcer)enforcer)));
        this.getEnforcers(LicensePolicy.Rule.DENY).forEach(enforcer -> results.putAll(this.apply(licenseMap, (LicensePolicyEnforcer)enforcer)));
        return results;
    }

    public Map<Artifact, LicensePolicyEnforcerResult> apply(LicenseMap licenseMap) {
        return this.apply(licenseMap.getLicenseMap());
    }

    public void setEnforcers(Set<LicensePolicyEnforcer> enforcers) {
        this.enforcers = enforcers;
    }

    public Set<LicensePolicyEnforcer> getEnforcers() {
        return this.enforcers;
    }

    public Set<LicensePolicy> getPolicies() {
        return this.policies;
    }

    public LicensePolicyEnforcer<?> getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void setDefaultPolicy(LicensePolicyEnforcer defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }
}

