/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spring;

import java.sql.Connection;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringConnectionProvider
implements Provider<Connection> {
    private final DataSource dataSource;

    public SpringConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection get() {
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        if (!DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
            throw new IllegalStateException("Connection is not transactional");
        }
        return connection;
    }
}

