/*
 * Decompiled with CFR 0.152.
 */
package com.netaporter.uri.parsing;

import com.netaporter.uri.PathPart;
import com.netaporter.uri.QueryString;
import com.netaporter.uri.Uri;
import com.netaporter.uri.config.UriConfig;
import com.netaporter.uri.parsing.DefaultUriParser;
import com.netaporter.uri.parsing.MatrixParamSupport;
import java.io.Serializable;
import java.net.URISyntaxException;
import org.parboiled2.ParseError;
import org.parboiled2.Parser;
import org.parboiled2.ParserInput;
import org.parboiled2.ParserInput$;
import org.parboiled2.Position;
import org.parboiled2.Rule;
import org.parboiled2.support.Unpack$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import shapeless.;
import shapeless.HNil;

public final class UriParser$ {
    public static UriParser$ MODULE$;

    static {
        new UriParser$();
    }

    public Uri parse(String s, UriConfig config) {
        Uri uri;
        Object parser = config.matrixParams() ? new MatrixParamSupport(s, config){
            private final Function2<String, Seq<Tuple2<String, Option<String>>>, Product> extractPathPartWithMatrixParams;

            public Rule<HNil, .colon.colon<String, HNil>> _plainPathPart() {
                return MatrixParamSupport._plainPathPart$(this);
            }

            public Rule<HNil, .colon.colon<Tuple2<String, Option<String>>, HNil>> _matrixParam() {
                return MatrixParamSupport._matrixParam$(this);
            }

            public Rule<HNil, .colon.colon<PathPart, HNil>> _pathSegment() {
                return MatrixParamSupport._pathSegment$(this);
            }

            public Function2<String, Seq<Tuple2<String, Option<String>>>, Product> extractPathPartWithMatrixParams() {
                return this.extractPathPartWithMatrixParams;
            }

            public void com$netaporter$uri$parsing$MatrixParamSupport$_setter_$extractPathPartWithMatrixParams_$eq(Function2<String, Seq<Tuple2<String, Option<String>>>, Product> x$1) {
                this.extractPathPartWithMatrixParams = x$1;
            }
            {
                MatrixParamSupport.$init$(this);
            }
        } : new DefaultUriParser((ParserInput)ParserInput$.MODULE$.apply(s), config);
        boolean bl = false;
        Failure failure = null;
        Object p = parser;
        Try try_ = (Try)p.__run(() -> UriParser$.$anonfun$parse$1((DefaultUriParser)p), Parser.DeliveryScheme$.MODULE$.Try(Unpack$.MODULE$.single()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable pe = failure.exception();
                if (pe instanceof ParseError) {
                    ParseError parseError = (ParseError)pe;
                    Position position = parseError.position();
                    scala.collection.immutable.Seq formatTraces = parseError.traces();
                    throw new URISyntaxException(s, "Invalid URI could not be parsed. " + formatTraces, position.index());
                }
            }
            if (bl) {
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Uri uri2 = uri = (Uri)success.value();
        return uri2;
    }

    public QueryString parseQuery(String s, UriConfig config) {
        QueryString queryString;
        String withQuestionMark = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head()) == '?' ? s : "?" + s;
        DefaultUriParser parser = new DefaultUriParser((ParserInput)ParserInput$.MODULE$.apply(withQuestionMark), config);
        boolean bl = false;
        Failure failure = null;
        DefaultUriParser p = parser;
        Try try_ = (Try)p.__run((Function0 & Serializable & scala.Serializable)() -> p._queryString(), Parser.DeliveryScheme$.MODULE$.Try(Unpack$.MODULE$.single()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable pe = failure.exception();
                if (pe instanceof ParseError) {
                    ParseError parseError = (ParseError)pe;
                    Position position = parseError.position();
                    scala.collection.immutable.Seq formatTraces = parseError.traces();
                    throw new URISyntaxException(s, "Invalid URI could not be parsed. " + formatTraces, position.index());
                }
            }
            if (bl) {
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        QueryString queryString2 = queryString = (QueryString)success.value();
        return queryString2;
    }

    public static final /* synthetic */ Rule $anonfun$parse$1(DefaultUriParser p$1) {
        return p$1._uri();
    }

    private UriParser$() {
        MODULE$ = this;
    }
}

