/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.leader;

import com.google.common.base.Preconditions;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.ACLPathAndBytesable;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.recipes.leader.LeaderSelector;
import com.netflix.curator.framework.recipes.leader.Participant;
import com.netflix.curator.framework.recipes.locks.LockInternals;
import com.netflix.curator.framework.recipes.locks.LockInternalsSorter;
import com.netflix.curator.framework.recipes.locks.StandardLockInternalsDriver;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.framework.state.ConnectionStateListener;
import com.netflix.curator.utils.ZKPaths;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderLatch
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String latchPath;
    private final String id;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.CONNECTED);
    private final AtomicBoolean hasLeadership = new AtomicBoolean(false);
    private final ConnectionStateListener listener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            LeaderLatch.this.handleStateChange(newState);
        }
    };
    private volatile String ourPath = null;
    private static final String LOCK_NAME = "latch-";
    private static final LockInternalsSorter sorter = new LockInternalsSorter(){

        @Override
        public String fixForSorting(String str, String lockName) {
            return StandardLockInternalsDriver.standardFixForSorting(str, lockName);
        }
    };

    public LeaderLatch(CuratorFramework client, String latchPath) {
        this(client, latchPath, "");
    }

    public LeaderLatch(CuratorFramework client, String latchPath, String id) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        this.latchPath = (String)Preconditions.checkNotNull((Object)latchPath, (Object)"mutexPath cannot be null");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
    }

    public void start() throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Already started");
        this.client.getConnectionStateListenable().addListener((Object)this.listener);
        this.client.newNamespaceAwareEnsurePath(this.latchPath).ensure(this.client.getZookeeperClient());
        this.internalStart();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.STARTED, State.CLOSED), (Object)"Not started");
        try {
            ((Pathable)this.client.delete().guaranteed().inBackground()).forPath(this.ourPath);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.client.getConnectionStateListenable().removeListener((Object)this.listener);
            this.setLeadership(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException, EOFException {
        LeaderLatch leaderLatch = this;
        synchronized (leaderLatch) {
            while (this.state.get() == State.STARTED && !this.hasLeadership.get()) {
                this.wait();
            }
        }
        if (this.state.get() != State.STARTED) {
            throw new EOFException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        LeaderLatch leaderLatch = this;
        synchronized (leaderLatch) {
            long elapsed;
            for (long waitNanos = TimeUnit.NANOSECONDS.convert(timeout, unit); waitNanos > 0L && this.state.get() == State.STARTED && !this.hasLeadership.get(); waitNanos -= elapsed) {
                long startNanos = System.nanoTime();
                TimeUnit.NANOSECONDS.timedWait(this, waitNanos);
                elapsed = System.nanoTime() - startNanos;
            }
        }
        return this.hasLeadership();
    }

    public String getId() {
        return this.id;
    }

    public Collection<Participant> getParticipants() throws Exception {
        Collection<String> participantNodes = LockInternals.getParticipantNodes(this.client, this.latchPath, LOCK_NAME, sorter);
        return LeaderSelector.getParticipants(this.client, participantNodes);
    }

    public Participant getLeader() throws Exception {
        Collection<String> participantNodes = LockInternals.getParticipantNodes(this.client, this.latchPath, LOCK_NAME, sorter);
        return LeaderSelector.getLeader(this.client, participantNodes);
    }

    public boolean hasLeadership() {
        return this.state.get() == State.STARTED && this.hasLeadership.get() && this.connectionState.get() == ConnectionState.CONNECTED;
    }

    private void internalStart() throws Exception {
        this.hasLeadership.set(false);
        if (this.ourPath != null) {
            ((Pathable)this.client.delete().guaranteed().inBackground()).forPath(this.ourPath);
        }
        this.ourPath = (String)((ACLPathAndBytesable)this.client.create().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(ZKPaths.makePath((String)this.latchPath, (String)LOCK_NAME), LeaderSelector.getIdBytes(this.id));
        this.checkForLeadership();
    }

    private void checkForLeadership() throws Exception {
        List<String> sortedChildren = LockInternals.getSortedChildren(this.client, this.latchPath, LOCK_NAME, sorter);
        if (sortedChildren.size() == 0) {
            throw new Exception("no children - unexpected state");
        }
        int ourIndex = sortedChildren.indexOf(ZKPaths.getNodeFromPath((String)this.ourPath));
        if (ourIndex == 0) {
            this.setLeadership(true);
        } else {
            final String ourPathWhenWatched = this.ourPath;
            String watchPath = sortedChildren.get(ourIndex - 1);
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent event) {
                    if (event.getType() == Watcher.Event.EventType.NodeDeleted && LeaderLatch.this.ourPath != null && LeaderLatch.this.ourPath.equals(ourPathWhenWatched)) {
                        try {
                            LeaderLatch.this.checkForLeadership();
                        }
                        catch (Exception ex) {
                            LeaderLatch.this.log.error("An error ocurred checking the leadership.", (Throwable)ex);
                        }
                    }
                }
            };
            if (((BackgroundPathable)this.client.checkExists().usingWatcher(watcher)).forPath(ZKPaths.makePath((String)this.latchPath, (String)watchPath)) == null) {
                this.checkForLeadership();
            }
        }
    }

    private void handleStateChange(ConnectionState newState) {
        ConnectionState previousState;
        if (newState == ConnectionState.RECONNECTED) {
            newState = ConnectionState.CONNECTED;
        }
        if ((previousState = this.connectionState.getAndSet(newState)) == ConnectionState.LOST && newState == ConnectionState.CONNECTED) {
            try {
                this.internalStart();
            }
            catch (Exception e) {
                this.log.error("Could not restart leader latch", (Throwable)e);
                this.connectionState.set(ConnectionState.LOST);
                this.setLeadership(false);
            }
        }
    }

    private synchronized void setLeadership(boolean newValue) {
        this.hasLeadership.set(newValue);
        this.doNotify();
    }

    private synchronized void doNotify() {
        this.notifyAll();
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

