/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.aop.aspectj;

import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.collapser.CommandCollapser;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutor;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.GenericHystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.utils.AopUtils;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class HystrixCommandAspect {
    @Pointcut(value="@annotation(com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand)")
    public void hystrixCommandAnnotationPointcut() {
    }

    @Around(value="hystrixCommandAnnotationPointcut()")
    public Object methodsAnnotatedWithHystrixCommand(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        Method method = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
        Object obj = joinPoint.getTarget();
        Object[] args = joinPoint.getArgs();
        Validate.notNull((Object)method, (String)"failed to get method from joinPoint: %s", (Object[])new Object[]{joinPoint});
        HystrixCommand hystrixCommand = method.getAnnotation(HystrixCommand.class);
        HystrixCollapser hystrixCollapser = method.getAnnotation(HystrixCollapser.class);
        ExecutionType executionType = ExecutionType.getExecutionType(method.getReturnType());
        Method cacheKeyMethod = AopUtils.getMethodFromTarget((JoinPoint)joinPoint, hystrixCommand.cacheKeyMethod());
        MetaHolder metaHolder = MetaHolder.builder().args(args).method(method).obj(obj).proxyObj(joinPoint.getThis()).cacheKeyMethod(cacheKeyMethod).executionType(executionType).hystrixCommand(hystrixCommand).hystrixCollapser(hystrixCollapser).defaultCommandKey(method.getName()).defaultCollapserKey(method.getName()).defaultGroupKey(obj.getClass().getSimpleName()).build();
        Object executable = hystrixCollapser != null ? new CommandCollapser(metaHolder) : GenericHystrixCommandFactory.getInstance().create(metaHolder, null);
        try {
            result = CommandExecutor.execute((HystrixExecutable)executable, executionType);
        }
        catch (HystrixBadRequestException e) {
            throw e.getCause();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return result;
    }
}

