/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.base.Throwables;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.CommandSetterBuilder;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractHystrixCommand<T>
extends HystrixCommand<T> {
    private CommandActions commandActions;
    private final Map<String, Object> commandProperties;
    private final Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests;
    private final Class<? extends Throwable>[] ignoreExceptions;
    private final ExecutionType executionType;

    protected AbstractHystrixCommand(CommandSetterBuilder setterBuilder, CommandActions commandActions, Map<String, Object> commandProperties, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests, Class<? extends Throwable>[] ignoreExceptions, ExecutionType executionType) {
        super(setterBuilder.build());
        this.commandActions = commandActions;
        this.commandProperties = commandProperties;
        this.collapsedRequests = collapsedRequests;
        this.ignoreExceptions = ignoreExceptions;
        this.executionType = executionType;
        HystrixPropertiesManager.setCommandProperties(commandProperties, this.getCommandKey().name());
    }

    CommandAction getCommandAction() {
        return this.commandActions.getCommandAction();
    }

    CommandAction getFallbackAction() {
        return this.commandActions.getFallbackAction();
    }

    CommandAction getCacheKeyAction() {
        return this.commandActions.getCacheKeyAction();
    }

    Map<String, Object> getCommandProperties() {
        return this.commandProperties;
    }

    Collection<HystrixCollapser.CollapsedRequest<Object, Object>> getCollapsedRequests() {
        return this.collapsedRequests;
    }

    Class<? extends Throwable>[] getIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    protected String getCacheKey() {
        String key = this.commandActions.getCacheKeyAction() != null ? String.valueOf(this.commandActions.getCacheKeyAction().execute(this.executionType)) : super.getCacheKey();
        return key;
    }

    boolean isIgnorable(Throwable throwable) {
        if (this.ignoreExceptions == null || this.ignoreExceptions.length == 0) {
            return false;
        }
        for (Class<? extends Throwable> ignoreException : this.ignoreExceptions) {
            if (!throwable.getClass().isAssignableFrom(ignoreException)) continue;
            return true;
        }
        return false;
    }

    Object process(Action action) throws RuntimeException {
        Object result;
        try {
            result = action.execute();
        }
        catch (Throwable throwable) {
            if (this.isIgnorable(throwable)) {
                throw new HystrixBadRequestException(throwable.getMessage(), throwable);
            }
            throw Throwables.propagate((Throwable)throwable);
        }
        return result;
    }

    protected abstract T run() throws Exception;

    protected T getFallback() {
        throw new RuntimeException("No fallback available.", this.getFailedExecutionException());
    }

    abstract class Action {
        Action() {
        }

        abstract Object execute();
    }
}

