/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.contrib.javanica.command.CommandAction;

public class CommandActions {
    private final CommandAction commandAction;
    private final CommandAction fallbackAction;
    private final CommandAction cacheKeyAction;

    public CommandActions(Builder builder) {
        this.commandAction = builder.commandAction;
        this.fallbackAction = builder.fallbackAction;
        this.cacheKeyAction = builder.cacheKeyAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CommandAction getCommandAction() {
        return this.commandAction;
    }

    public CommandAction getFallbackAction() {
        return this.fallbackAction;
    }

    public CommandAction getCacheKeyAction() {
        return this.cacheKeyAction;
    }

    public static class Builder {
        private CommandAction commandAction;
        private CommandAction fallbackAction;
        private CommandAction cacheKeyAction;

        public Builder commandAction(CommandAction pCommandAction) {
            this.commandAction = pCommandAction;
            return this;
        }

        public Builder fallbackAction(CommandAction pFallbackAction) {
            this.fallbackAction = pFallbackAction;
            return this;
        }

        public Builder cacheKeyAction(CommandAction pCacheKeyAction) {
            this.cacheKeyAction = pCacheKeyAction;
            return this;
        }

        public CommandActions build() {
            return new CommandActions(this);
        }
    }
}

