/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.GenericCommand;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.exception.FallbackInvocationException;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BatchHystrixCommand
extends AbstractHystrixCommand<List<Optional<Object>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericCommand.class);
    private boolean fallbackEnabled;

    protected BatchHystrixCommand(HystrixCommandBuilder builder) {
        super(builder);
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    public void setFallbackEnabled(boolean fallbackEnabled) {
        this.fallbackEnabled = fallbackEnabled;
    }

    @Override
    protected List<Optional<Object>> run() throws Exception {
        ArrayList response = Lists.newArrayList();
        for (HystrixCollapser.CollapsedRequest<Object, Object> request : this.getCollapsedRequests()) {
            Object[] args = (Object[])request.getArgument();
            try {
                response.add(Optional.of((Object)(this.fallbackEnabled ? this.processWithFallback(args) : this.process(args))));
            }
            catch (Exception ex) {
                request.setException(ex);
                response.add(Optional.absent());
            }
        }
        return response;
    }

    private Object process(final Object[] args) throws Exception {
        return this.process(new AbstractHystrixCommand.Action(){

            @Override
            Object execute() {
                return BatchHystrixCommand.this.getCommandAction().executeWithArgs(BatchHystrixCommand.this.getExecutionType(), args);
            }
        });
    }

    private Object processWithFallback(Object[] args) throws Exception {
        Object result;
        try {
            result = this.process(args);
        }
        catch (Exception ex) {
            if (ex instanceof HystrixBadRequestException) {
                throw ex;
            }
            result = this.getFallbackAction() != null ? this.processFallback(args) : super.getFallback();
        }
        return result;
    }

    private Object processFallback(final Object[] args) {
        if (this.getFallbackAction() != null) {
            final CommandAction commandAction = this.getFallbackAction();
            try {
                return this.process(new AbstractHystrixCommand.Action(){

                    @Override
                    Object execute() {
                        return commandAction.executeWithArgs(ExecutionType.SYNCHRONOUS, args);
                    }
                });
            }
            catch (Throwable e) {
                LOGGER.error(AbstractHystrixCommand.FallbackErrorMessageBuilder.create().append(commandAction, e).build());
                throw new FallbackInvocationException(e.getCause());
            }
        }
        return super.getFallback();
    }
}

