/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.service;

import com.netflix.iep.service.Service;
import com.netflix.iep.service.State;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public abstract class AbstractService
implements Service {
    private String name;
    private volatile State state;

    public AbstractService() {
        this(null);
    }

    public AbstractService(String string) {
        this.name = string == null ? this.getClass().getSimpleName() : string;
        this.state = State.NEW;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public boolean isHealthy() {
        return this.state == State.RUNNING;
    }

    @Override
    public final State state() {
        return this.state;
    }

    @PostConstruct
    public final synchronized void start() throws Exception {
        if (this.state != State.NEW) {
            throw new IllegalStateException("attempting to start service '" + this.name + "' from state " + this.state.name());
        }
        this.state = State.STARTING;
        try {
            this.startImpl();
            this.state = State.RUNNING;
        }
        catch (Exception exception) {
            this.state = State.FAILED;
            throw exception;
        }
    }

    @PreDestroy
    public final synchronized void stop() throws Exception {
        if (this.state == State.STARTING || this.state == State.RUNNING) {
            this.state = State.STOPPING;
            try {
                this.stopImpl();
                this.state = State.TERMINATED;
            }
            catch (Exception exception) {
                this.state = State.FAILED;
                throw exception;
            }
        }
    }

    protected abstract void startImpl() throws Exception;

    protected abstract void stopImpl() throws Exception;
}

