/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.service;

import com.netflix.iep.service.Service;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ServiceManager {
    private final List<Service> services = new ArrayList<Service>();

    @Inject
    public ServiceManager(Set<Service> set) {
        this.services.addAll(set);
        Collections.sort(this.services, new Comparator<Service>(){

            @Override
            public int compare(Service service, Service service2) {
                return service.name().compareTo(service2.name());
            }
        });
    }

    public List<Service> services() {
        return Collections.unmodifiableList(this.services);
    }

    public boolean isHealthy() {
        boolean bl = true;
        for (Service service : this.services) {
            bl = bl && service.isHealthy();
        }
        return bl;
    }
}

