/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.netflix.config.ConfigurationManager;
import com.netflix.karyon.server.eureka.AsyncHealthCheckInvocationStrategy;
import com.netflix.karyon.server.eureka.HealthCheckInvocationStrategy;
import com.netflix.karyon.spi.HealthCheckHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckModule.class);

    protected void configure() {
        this.bindHealthCheckStrategy();
        this.bindHealthCheckHandler();
    }

    protected void bindHealthCheckStrategy() {
        this.bindACustomClass(this.binder(), "com.netflix.karyon.health.check.strategy", HealthCheckInvocationStrategy.class, "No health check invocation strategy specified, using the default strategy %s. In order to override this behavior you provide an implementation of %s and specify the fully qualified class name of the implementation in the property %s", AsyncHealthCheckInvocationStrategy.class.getName(), HealthCheckInvocationStrategy.class.getName(), "com.netflix.karyon.health.check.strategy");
    }

    protected void bindHealthCheckHandler() {
        this.bindACustomClass(this.binder(), "com.netflix.karyon.health.check.handler.classname", HealthCheckHandler.class, "No health check handler defined. This means your application can not provide meaningful health state to external entities. It is highly recommended that you provide an implementation of %s and specify the fully qualified class name of the implementation in the property %s", HealthCheckHandler.class.getName(), "com.netflix.karyon.health.check.handler.classname");
    }

    private <T> boolean bindACustomClass(Binder binder, String customClassPropName, Class<T> bindTo, String propertNotFoundErrMsg, Object ... arguments) {
        boolean bound;
        block5: {
            bound = false;
            String customClassName = ConfigurationManager.getConfigInstance().getString(customClassPropName);
            if (null != customClassName) {
                Object customClass = null;
                try {
                    Class<?> aClass = Class.forName(customClassName);
                    if (bindTo.isAssignableFrom(aClass)) {
                        binder.bind(bindTo).to(aClass);
                        bound = true;
                        break block5;
                    }
                    logger.warn(String.format("Binding for %s failed, %s can not be assigned to %s.", bindTo.getName(), customClassName, bindTo.getName()));
                }
                catch (ClassNotFoundException e) {
                    logger.error(String.format("Binding for %s failed, class %s specified as property %s can not be found.", bindTo.getName(), customClass, customClassPropName), (Throwable)e);
                }
            } else {
                logger.info(String.format(propertNotFoundErrMsg, arguments));
            }
        }
        return bound;
    }
}

