/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server.eureka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.guice.lazy.LazySingleton;
import com.netflix.karyon.server.eureka.HealthCheckInvocationStrategy;
import com.netflix.karyon.spi.HealthCheckHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class AsyncHealthCheckInvocationStrategy
implements HealthCheckInvocationStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(AsyncHealthCheckInvocationStrategy.class);
    @Configuration(value="com.netflix.karyon.health.check.default.timeout.ms", documentation="Default timeout value for healthchecks in milliseconds.")
    protected int HEALTH_CHECK_TIMEOUT_DEFAULT = 1000;
    private final DynamicIntProperty HEALTH_CHECK_TIMEOUT_MILLIS;
    private final HealthCheckHandler healthCheckHandler;
    private AtomicReference<Future<Integer>> currentFuture = new AtomicReference();
    private ExecutorService executor;
    private AtomicInteger executeCounter = new AtomicInteger(0);
    private AtomicInteger invokeCounter = new AtomicInteger(0);

    @Inject
    public AsyncHealthCheckInvocationStrategy(HealthCheckHandler healthCheckHandler) {
        logger.info(String.format("Application health check handler to be used by karyon: %s", healthCheckHandler.getClass().getName()));
        this.healthCheckHandler = healthCheckHandler;
        this.currentFuture = new AtomicReference();
        this.HEALTH_CHECK_TIMEOUT_MILLIS = DynamicPropertyFactory.getInstance().getIntProperty("com.netflix.karyon.health.check.timeout.ms", this.HEALTH_CHECK_TIMEOUT_DEFAULT);
    }

    @VisibleForTesting
    public AsyncHealthCheckInvocationStrategy(HealthCheckHandler healthCheckHandler, int timeout) {
        logger.info(String.format("Application health check handler to be used by karyon: %s", healthCheckHandler.getClass().getName()));
        this.healthCheckHandler = healthCheckHandler;
        this.currentFuture = new AtomicReference();
        this.HEALTH_CHECK_TIMEOUT_MILLIS = DynamicPropertyFactory.getInstance().getIntProperty("com.netflix.karyon.health.check.timeout.ms", timeout);
    }

    @PostConstruct
    public synchronized void start() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("AsyncHealthCheck-%d").setDaemon(true).build());
        }
    }

    @Override
    public int invokeCheck() throws TimeoutException {
        Future<Integer> pending;
        this.invokeCounter.incrementAndGet();
        while (true) {
            SettableFuture future;
            if (this.currentFuture.compareAndSet(null, (Future<Integer>)(future = SettableFuture.create()))) {
                this.executor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AsyncHealthCheckInvocationStrategy.this.executeCounter.incrementAndGet();
                        try {
                            future.set((Object)AsyncHealthCheckInvocationStrategy.this.healthCheckHandler.getStatus());
                        }
                        catch (Exception e) {
                            logger.debug("Async health check had an error {}", (Object)e.getMessage());
                            future.set((Object)500);
                        }
                        finally {
                            AsyncHealthCheckInvocationStrategy.this.currentFuture.set(null);
                        }
                    }
                });
                try {
                    return (Integer)future.get((long)this.HEALTH_CHECK_TIMEOUT_MILLIS.get(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    throw new TimeoutException();
                }
                catch (Exception e) {
                    future.set((Object)500);
                    continue;
                }
            }
            pending = this.currentFuture.get();
            if (pending != null) break;
        }
        try {
            return pending.get(this.HEALTH_CHECK_TIMEOUT_MILLIS.get(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new TimeoutException();
        }
        catch (Exception e) {
            return 500;
        }
    }

    @Override
    public HealthCheckHandler getHandler() {
        return this.healthCheckHandler;
    }

    int getInvokeCounter() {
        return this.invokeCounter.get();
    }

    int getExecuteCounter() {
        return this.executeCounter.get();
    }

    public synchronized void stop() throws InterruptedException {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

