/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server.eureka;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.CloudInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.guice.lazy.LazySingleton;
import com.netflix.karyon.server.eureka.AsyncHealthCheckInvocationStrategy;
import com.netflix.karyon.server.eureka.EurekaHealthCheckCallback;
import com.netflix.karyon.server.eureka.EurekaHealthCheckHandler;
import com.netflix.karyon.server.eureka.HealthCheckInvocationStrategy;
import com.netflix.karyon.spi.ServiceRegistryClient;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class EurekaHandler
implements ServiceRegistryClient {
    protected static final Logger logger = LoggerFactory.getLogger(EurekaHandler.class);
    private EurekaHealthCheckCallback eurekaHealthCheckCallback;
    private HealthCheckInvocationStrategy healthCheckInvocationStrategy;
    private final EurekaHealthCheckHandler healthCheckHandler;
    private AtomicBoolean registered = new AtomicBoolean();
    @Configuration(value="com.netflix.karyon.eureka.properties.prefix", documentation="Namespace for eureka related properties.")
    protected String eurekaNamespace = "eureka";
    @Configuration(value="com.netflix.karyon.eureka.use.healthcheck.handler", documentation="Uses the eureka healthcheck handler semantics as opposed to a binary handler.")
    protected boolean useEurekaHealthCheckHandler = false;
    @Configuration(value="com.netflix.karyon.eureka.client.properties.prefix", documentation="Namespace for eureka client related properties.")
    protected String eurekaClientNamespace;
    @Configuration(value="com.netflix.karyon.eureka.datacenter.type", documentation="Datacenter type used for initializing appropriate eureka instance configuration.")
    protected String datacenterType;

    @Inject
    public EurekaHandler(EurekaHealthCheckCallback eurekaHealthCheckCallback, HealthCheckInvocationStrategy healthCheckInvocationStrategy, EurekaHealthCheckHandler healthCheckHandler) {
        this.eurekaHealthCheckCallback = eurekaHealthCheckCallback;
        this.healthCheckInvocationStrategy = healthCheckInvocationStrategy;
        this.healthCheckHandler = healthCheckHandler;
    }

    @PostConstruct
    public void postConfig() {
        if (!this.eurekaNamespace.endsWith(".")) {
            this.eurekaNamespace = this.eurekaNamespace + ".";
        }
        if (null == this.eurekaClientNamespace) {
            this.eurekaClientNamespace = this.eurekaNamespace;
        } else if (!this.eurekaClientNamespace.endsWith(".")) {
            this.eurekaClientNamespace = this.eurekaClientNamespace + ".";
        }
        this.register();
    }

    public void register() {
        if (this.isEurekaDisabled()) {
            logger.info("Eureka is disabled, skipping instance's eureka registration.");
            return;
        }
        if (!this.registered.compareAndSet(false, true)) {
            logger.info("Eureka handler already registered, skipping registration.");
            return;
        }
        EurekaInstanceConfig eurekaInstanceConfig = this.createEurekaInstanceConfig();
        DiscoveryManager.getInstance().initComponent(eurekaInstanceConfig, (EurekaClientConfig)new DefaultEurekaClientConfig(this.eurekaClientNamespace));
        if (this.useEurekaHealthCheckHandler) {
            DiscoveryManager.getInstance().getDiscoveryClient().registerHealthCheck((HealthCheckHandler)this.healthCheckHandler);
        } else if (null != this.eurekaHealthCheckCallback) {
            DiscoveryManager.getInstance().getDiscoveryClient().registerHealthCheckCallback((HealthCheckCallback)this.eurekaHealthCheckCallback);
        }
    }

    protected EurekaInstanceConfig createEurekaInstanceConfig() {
        CloudInstanceConfig eurekaInstanceConfig;
        DataCenterInfo.Name dcType = DataCenterInfo.Name.MyOwn;
        if (null != this.datacenterType) {
            try {
                dcType = DataCenterInfo.Name.valueOf((String)this.datacenterType);
            }
            catch (IllegalArgumentException e) {
                logger.warn(String.format("Illegal value %s for eureka datacenter provided in property %s. Ignoring the same and defaulting to %s", this.datacenterType, "com.netflix.karyon.eureka.datacenter.type", DataCenterInfo.Name.MyOwn));
            }
        }
        switch (dcType) {
            case Amazon: {
                eurekaInstanceConfig = new CloudInstanceConfig(this.eurekaNamespace);
                break;
            }
            case Netflix: {
                eurekaInstanceConfig = new MyDataCenterInstanceConfig(this.eurekaNamespace, new DataCenterInfo(){

                    public DataCenterInfo.Name getName() {
                        return DataCenterInfo.Name.Netflix;
                    }
                });
                break;
            }
            default: {
                eurekaInstanceConfig = new MyDataCenterInstanceConfig(this.eurekaNamespace);
            }
        }
        return eurekaInstanceConfig;
    }

    public void markAsUp() {
        if (this.isEurekaDisabled()) {
            logger.info("Eureka is disabled, skipping instance's eureka update to up.");
            return;
        }
        ApplicationInfoManager.getInstance().setInstanceStatus(InstanceInfo.InstanceStatus.UP);
    }

    public void markAsDown() {
        if (this.isEurekaDisabled()) {
            logger.info("Eureka is disabled, skipping instance's eureka update to down.");
            return;
        }
        DiscoveryManager.getInstance().shutdownComponent();
        if (null != this.healthCheckInvocationStrategy && AsyncHealthCheckInvocationStrategy.class.isAssignableFrom(this.healthCheckInvocationStrategy.getClass())) {
            try {
                ((AsyncHealthCheckInvocationStrategy)this.healthCheckInvocationStrategy).stop();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                logger.error("Interrupted while stopping the async health check invocation strategy. Ignoring.", (Throwable)e);
            }
        }
    }

    public void updateStatus(ServiceRegistryClient.ServiceStatus newStatus) {
        Preconditions.checkNotNull((Object)newStatus, (Object)"Service status can not be null.");
        switch (newStatus) {
            case UP: {
                this.markAsUp();
                break;
            }
            case DOWN: {
                this.markAsDown();
            }
        }
    }

    private boolean isEurekaDisabled() {
        return ConfigurationManager.getConfigInstance().getBoolean("com.netflix.karyon.eureka.disable", false);
    }
}

