/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.inject.Injector;
import com.netflix.config.ConfigurationManager;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.lifecycle.LifecycleManager;
import com.netflix.karyon.server.ServerBootstrap;
import com.netflix.karyon.server.lifecycle.ServerInitializer;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KaryonServer
implements Closeable {
    protected static final Logger logger = LoggerFactory.getLogger(KaryonServer.class);
    private LifecycleManager lifecycleManager;
    private Injector injector;
    private ServerInitializer initializer;

    public synchronized Injector initialize() {
        if (null != this.injector) {
            return this.injector;
        }
        String appId = ConfigurationManager.getDeploymentContext().getApplicationId();
        if (null != appId) {
            try {
                ConfigurationManager.loadCascadedPropertiesFromResources((String)appId);
            }
            catch (IOException e) {
                logger.error(String.format("Failed to load properties for application id: %s and environment: %s. This is ok, if you do not have application level properties.", appId, ConfigurationManager.getDeploymentContext().getDeploymentEnvironment()), (Throwable)e);
            }
        } else {
            logger.warn("Application identifier not defined, skipping application level properties loading. You must set a property 'archaius.deployment.applicationId' to be able to load application level properties.");
        }
        String bootstrapClassName = ConfigurationManager.getConfigInstance().getString("com.netflix.karyon.server.bootstrap.class");
        ServerBootstrap bootstrap = null == bootstrapClassName ? new ServerBootstrap() : this.instantiateBootstrapClass(bootstrapClassName);
        LifecycleInjectorBuilder injectorBuilder = bootstrap.bootstrap();
        bootstrap.beforeInjectorCreation(injectorBuilder);
        this.injector = injectorBuilder.createInjector();
        return this.injector;
    }

    public void start() throws Exception {
        this.lifecycleManager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
        this.lifecycleManager.start();
        this.initializer = (ServerInitializer)this.injector.getInstance(ServerInitializer.class);
        this.initializer.initialize(this.injector);
    }

    @Override
    public void close() throws IOException {
        logger.info("Shutting down karyon.");
        if (null != this.initializer) {
            this.initializer.close();
        }
        Closeables.closeQuietly((Closeable)this.lifecycleManager);
        logger.info("Successfully shut down karyon.");
    }

    private ServerBootstrap instantiateBootstrapClass(String bootstrapClassName) {
        try {
            return (ServerBootstrap)Class.forName(bootstrapClassName).newInstance();
        }
        catch (InstantiationException e) {
            logger.error(String.format("Failed to instantiate server bootstrap class %s", bootstrapClassName), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(String.format("Access bootstrap class %s is not allowed.", bootstrapClassName), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(String.format("Bootstrap class %s not found.", bootstrapClassName), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        catch (ClassCastException e) {
            logger.error(String.format("Bootstrap class %s should extend from %s", bootstrapClassName, ServerBootstrap.class.getName()), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

