/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.netflix.config.ConfigurationManager;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.configuration.ArchaiusConfigurationProvider;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.lifecycle.ClasspathScanner;
import com.netflix.karyon.spi.Application;
import com.netflix.karyon.spi.Component;
import com.netflix.karyon.spi.HealthCheckHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(ServerBootstrap.class);

    LifecycleInjectorBuilder bootstrap() {
        ArrayList<String> allBasePackages = new ArrayList<String>();
        allBasePackages.add("com.netflix");
        Collection<String> basePackages = this.getBasePackages();
        if (null != basePackages) {
            allBasePackages.addAll(basePackages);
        }
        ArrayList annotations = Lists.newArrayList();
        annotations.add(AutoBindSingleton.class);
        annotations.add(Inject.class);
        annotations.add(javax.inject.Inject.class);
        annotations.add(Application.class);
        annotations.add(Component.class);
        ClasspathScanner scanner = new ClasspathScanner(basePackages, (Collection)annotations);
        return LifecycleInjector.builder().usingBasePackages(allBasePackages).usingClasspathScanner(scanner).withBootstrapModule((BootstrapModule)new BootstrapModuleImpl());
    }

    protected void beforeInjectorCreation(LifecycleInjectorBuilder builderToBeUsed) {
    }

    protected void configureBootstrapBinder(BootstrapBinder bootstrapBinder) {
    }

    @Nullable
    protected Collection<String> getBasePackages() {
        ArrayList<String> toReturn = new ArrayList<String>();
        List basePackages = ConfigurationManager.getConfigInstance().getList("com.netflix.karyon.server.base.packages");
        for (Object basePackage : basePackages) {
            toReturn.add(String.valueOf(basePackage));
        }
        return toReturn;
    }

    private class BootstrapModuleImpl
    implements BootstrapModule {
        private BootstrapModuleImpl() {
        }

        public void configure(BootstrapBinder binder) {
            this.bindHealthCheckHandler(binder);
            binder.bindConfigurationProvider().to(ArchaiusConfigurationProvider.class);
            ServerBootstrap.this.configureBootstrapBinder(binder);
        }

        private void bindHealthCheckHandler(BootstrapBinder binder) {
            boolean bound;
            block6: {
                String healthCheckHandlerClass = ConfigurationManager.getConfigInstance().getString("com.netflix.karyon.health.check.handler.classname");
                bound = false;
                if (null != healthCheckHandlerClass) {
                    Object handlerClass = null;
                    try {
                        Class<?> aClass = Class.forName(healthCheckHandlerClass);
                        if (HealthCheckHandler.class.isAssignableFrom(aClass)) {
                            binder.bind(HealthCheckHandler.class).to(aClass);
                            bound = true;
                            break block6;
                        }
                        logger.warn(String.format("Health check handler %s specified does not implement %s. This handler will not be registered with karyon.", healthCheckHandlerClass, HealthCheckHandler.class.getName()));
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(String.format("Handler class %s specified as property %s can not be found. This handler will not be registered with karyon.", handlerClass, "com.netflix.karyon.health.check.handler.classname"), (Throwable)e);
                    }
                } else {
                    logger.info("No health check handler defined. This means your application can not provide meaningful health state to external entities. It is highly recommended that you provide an implementation of " + HealthCheckHandler.class.getName() + " and specify the fully qualified class name of the implementation in the property " + "com.netflix.karyon.health.check.handler.classname");
                }
            }
            if (!bound) {
                binder.bind(HealthCheckHandler.class).toInstance((Object)new HealthCheckHandler(){

                    public int checkHealth() {
                        return 200;
                    }
                });
            }
        }
    }
}

