/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server.eureka;

import com.google.inject.Inject;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.CloudInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.annotations.Configuration;
import com.netflix.karyon.server.eureka.EurekaHealthCheckCallback;
import com.netflix.karyon.server.utils.KaryonUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoBindSingleton
public class EurekaHandler {
    protected static final Logger logger = LoggerFactory.getLogger(EurekaHandler.class);
    private EurekaHealthCheckCallback eurekaHealthCheckCallback;
    @Configuration(value="com.netflix.karyon.eureka.properties.prefix", documentation="Namespace for eureka related properties.")
    private String eurekaNamespace = "eureka";
    @Configuration(value="com.netflix.karyon.eureka.datacenter.type", documentation="Datacenter type used for initializing appropriate eureka instance configuration.")
    private String datacenterType;

    @Inject
    public EurekaHandler(EurekaHealthCheckCallback eurekaHealthCheckCallback) {
        this.eurekaHealthCheckCallback = eurekaHealthCheckCallback;
    }

    @PostConstruct
    public void postConfig() {
        if (!this.eurekaNamespace.endsWith(".")) {
            this.eurekaNamespace = this.eurekaNamespace + ".";
        }
    }

    public void register() {
        CloudInstanceConfig eurekaInstanceConfig;
        if (!KaryonUtils.isCoreComponentEnabled("eureka")) {
            logger.info("Eureka is disabled, skipping instance's eureka registration.");
            return;
        }
        DataCenterInfo.Name dcType = DataCenterInfo.Name.MyOwn;
        if (null != this.datacenterType) {
            try {
                dcType = DataCenterInfo.Name.valueOf((String)this.datacenterType);
            }
            catch (IllegalArgumentException e) {
                logger.warn(String.format("Illegal value %s for eureka datacenter provided in property %s. Ignoring the same and defaulting to %s", this.datacenterType, "com.netflix.karyon.eureka.datacenter.type", DataCenterInfo.Name.MyOwn));
            }
        }
        switch (dcType) {
            case Netflix: 
            case Amazon: {
                eurekaInstanceConfig = new CloudInstanceConfig(this.eurekaNamespace);
                break;
            }
            default: {
                eurekaInstanceConfig = new MyDataCenterInstanceConfig(this.eurekaNamespace);
            }
        }
        DiscoveryManager.getInstance().initComponent((EurekaInstanceConfig)eurekaInstanceConfig, (EurekaClientConfig)new DefaultEurekaClientConfig(this.eurekaNamespace));
        DiscoveryManager.getInstance().getDiscoveryClient().registerHealthCheckCallback((HealthCheckCallback)this.eurekaHealthCheckCallback);
    }

    public void markAsUp() {
        if (!KaryonUtils.isCoreComponentEnabled("eureka")) {
            logger.info("Eureka is disabled, skipping instance's eureka update to up.");
            return;
        }
        ApplicationInfoManager.getInstance().setInstanceStatus(InstanceInfo.InstanceStatus.UP);
    }

    public void markAsDown() {
        if (!KaryonUtils.isCoreComponentEnabled("eureka")) {
            logger.info("Eureka is disabled, skipping instance's eureka update to down.");
            return;
        }
        ApplicationInfoManager.getInstance().setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
    }
}

