/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server.guice;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import com.netflix.karyon.server.KaryonServer;
import java.io.IOException;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBasedServer
extends GuiceServletContextListener {
    protected static final Logger logger = LoggerFactory.getLogger(GuiceBasedServer.class);
    private final KaryonServer server = new KaryonServer();

    protected Injector getInjector() {
        return this.server.initialize();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        try {
            this.server.start();
        }
        catch (Exception e) {
            logger.error("Error while starting karyon.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.server.close();
        }
        catch (IOException e) {
            logger.error("Error while stopping karyon.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

