/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.karyon.server.lifecycle;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.netflix.karyon.finder.ApplicationFinder;
import com.netflix.karyon.finder.ComponentFinder;
import com.netflix.karyon.server.eureka.EurekaHandler;
import java.io.Closeable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInitializer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ServerInitializer.class);
    private EurekaHandler eurekaHandler;
    private ApplicationFinder applicationFinder;
    private ComponentFinder componentFinder;

    @Inject
    public ServerInitializer(EurekaHandler eurekaHandler, ApplicationFinder applicationFinder, ComponentFinder componentFinder) {
        this.eurekaHandler = eurekaHandler;
        this.applicationFinder = applicationFinder;
        this.componentFinder = componentFinder;
    }

    public void initialize(Injector injector) {
        this.eurekaHandler.register();
        Set components = this.componentFinder.findComponents();
        for (Class component : components) {
            logger.info(String.format("Initializing component class: %s", component.getName()));
            try {
                injector.getInstance(component);
                logger.info(String.format("Successfully initialized component class: %s", component.getName()));
            }
            catch (Exception e) {
                logger.error("Failed to initialize component class. Stopping server initialization", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        Class application = this.applicationFinder.findApplication();
        if (null == application) {
            logger.info("No application classes found, this is fine if the application class is not annotated.");
        } else {
            logger.info(String.format("Initializing application class: %s", application.getName()));
            try {
                injector.getInstance(application);
                logger.info(String.format("Successfully initialized application class: %s", application.getName()));
            }
            catch (Exception e) {
                logger.error("Failed to initialize application class. Stopping server initialization", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.eurekaHandler.markAsUp();
    }

    @Override
    public void close() {
        this.eurekaHandler.markAsDown();
    }
}

