/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph;

import com.netflix.nfgraph.NFGraphModelHolder;
import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.spec.NFGraphSpec;

public abstract class NFGraph {
    protected final NFGraphSpec graphSpec;
    protected final NFGraphModelHolder modelHolder;

    protected NFGraph(NFGraphSpec graphSpec) {
        this.graphSpec = graphSpec;
        this.modelHolder = new NFGraphModelHolder();
    }

    protected NFGraph(NFGraphSpec graphSpec, NFGraphModelHolder modelHolder) {
        this.graphSpec = graphSpec;
        this.modelHolder = modelHolder;
    }

    public int getConnection(String nodeType, int ordinal, String propertyName) {
        return this.getConnection(0, nodeType, ordinal, propertyName);
    }

    public int getConnection(String connectionModel, String nodeType, int ordinal, String propertyName) {
        int connectionModelIndex = this.modelHolder.getModelIndex(connectionModel);
        return this.getConnection(connectionModelIndex, nodeType, ordinal, propertyName);
    }

    public OrdinalIterator getConnectionIterator(String nodeType, int ordinal, String propertyName) {
        return this.getConnectionIterator(0, nodeType, ordinal, propertyName);
    }

    public OrdinalIterator getConnectionIterator(String connectionModel, String nodeType, int ordinal, String propertyName) {
        int connectionModelIndex = this.modelHolder.getModelIndex(connectionModel);
        return this.getConnectionIterator(connectionModelIndex, nodeType, ordinal, propertyName);
    }

    public OrdinalSet getConnectionSet(String nodeType, int ordinal, String propertyName) {
        return this.getConnectionSet(0, nodeType, ordinal, propertyName);
    }

    public OrdinalSet getConnectionSet(String connectionModel, String nodeType, int ordinal, String propertyName) {
        int connectionModelIndex = this.modelHolder.getModelIndex(connectionModel);
        return this.getConnectionSet(connectionModelIndex, nodeType, ordinal, propertyName);
    }

    protected abstract int getConnection(int var1, String var2, int var3, String var4);

    protected abstract OrdinalSet getConnectionSet(int var1, String var2, int var3, String var4);

    protected abstract OrdinalIterator getConnectionIterator(int var1, String var2, int var3, String var4);
}

