/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph;

import com.netflix.nfgraph.OrdinalIterator;

public abstract class OrdinalSet {
    private static final int[] EMPTY_ORDINAL_ARRAY = new int[0];
    public static final OrdinalSet EMPTY_SET = new OrdinalSet(){

        @Override
        public boolean contains(int value) {
            return false;
        }

        @Override
        public int[] asArray() {
            return EMPTY_ORDINAL_ARRAY;
        }

        @Override
        public OrdinalIterator iterator() {
            return OrdinalIterator.EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public abstract boolean contains(int var1);

    public boolean containsAll(int ... values) {
        for (int value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public int[] asArray() {
        int[] arr = new int[this.size()];
        OrdinalIterator iter = this.iterator();
        int ordinal = iter.nextOrdinal();
        int i = 0;
        while (ordinal != Integer.MAX_VALUE) {
            arr[i++] = ordinal;
            ordinal = iter.nextOrdinal();
        }
        return arr;
    }

    public abstract OrdinalIterator iterator();

    public abstract int size();
}

