/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.build;

import com.netflix.nfgraph.NFGraphModelHolder;
import com.netflix.nfgraph.build.NFBuildGraphNode;
import com.netflix.nfgraph.spec.NFGraphSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NFBuildGraphNodeCache {
    private final NFGraphSpec graphSpec;
    private final NFGraphModelHolder buildGraphModelHolder;
    private final Map<String, List<NFBuildGraphNode>> nodesByOrdinal = new HashMap<String, List<NFBuildGraphNode>>();

    NFBuildGraphNodeCache(NFGraphSpec graphSpec, NFGraphModelHolder modelHolder) {
        this.graphSpec = graphSpec;
        this.buildGraphModelHolder = modelHolder;
    }

    NFBuildGraphNode getNode(String nodeType, int ordinal) {
        List<NFBuildGraphNode> nodes = this.getNodes(nodeType);
        while (ordinal >= nodes.size()) {
            nodes.add(null);
        }
        NFBuildGraphNode node = nodes.get(ordinal);
        if (node == null) {
            node = new NFBuildGraphNode(this.graphSpec.getNodeSpec(nodeType), ordinal, this.buildGraphModelHolder.size());
            nodes.set(ordinal, node);
        }
        return node;
    }

    public int numNodes(String nodeType) {
        return this.getNodes(nodeType).size();
    }

    public List<NFBuildGraphNode> getNodes(String nodeType) {
        List<NFBuildGraphNode> nodes = this.nodesByOrdinal.get(nodeType);
        if (nodes == null) {
            nodes = new ArrayList<NFBuildGraphNode>();
            this.nodesByOrdinal.put(nodeType, nodes);
        }
        return nodes;
    }
}

