/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.build;

import com.netflix.nfgraph.OrdinalIterator;
import java.util.Arrays;

public class NFBuildGraphOrdinalIterator
implements OrdinalIterator {
    private final int[] ordinals;
    private int currentPositionInList;
    private int previousOrdinal = Integer.MIN_VALUE;

    NFBuildGraphOrdinalIterator(int[] ordinals, int size) {
        this.ordinals = Arrays.copyOfRange(ordinals, 0, size);
        Arrays.sort(this.ordinals);
    }

    private NFBuildGraphOrdinalIterator(int[] ordinals) {
        this.ordinals = ordinals;
    }

    @Override
    public int nextOrdinal() {
        if (this.previousOrdinal == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int nextOrdinal = this.nextOrdinalInList();
        while (nextOrdinal == this.previousOrdinal) {
            nextOrdinal = this.nextOrdinalInList();
        }
        this.previousOrdinal = nextOrdinal;
        return nextOrdinal;
    }

    @Override
    public void reset() {
        this.previousOrdinal = 0;
        this.currentPositionInList = 0;
    }

    @Override
    public OrdinalIterator copy() {
        return new NFBuildGraphOrdinalIterator(this.ordinals);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    private int nextOrdinalInList() {
        if (this.currentPositionInList == this.ordinals.length) {
            return Integer.MAX_VALUE;
        }
        return this.ordinals[this.currentPositionInList++];
    }
}

