/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.util.ByteArrayReader;

public class HashSetOrdinalIterator
implements OrdinalIterator {
    private final ByteArrayReader reader;
    private final int beginOffset;
    private int offset = 0;
    private boolean firstValue;

    public HashSetOrdinalIterator(ByteArrayReader reader) {
        this.reader = reader;
        this.seekBeginByte();
        this.beginOffset = this.offset;
        this.firstValue = true;
    }

    @Override
    public int nextOrdinal() {
        this.seekBeginByte();
        if (this.offset == this.beginOffset) {
            if (!this.firstValue) {
                return Integer.MAX_VALUE;
            }
            this.firstValue = false;
        }
        int value = this.reader.getByte(this.offset);
        this.nextOffset();
        while ((this.reader.getByte(this.offset) & 0x80) != 0) {
            value <<= 7;
            value |= this.reader.getByte(this.offset) & 0x7F;
            this.nextOffset();
        }
        return value - 1;
    }

    @Override
    public void reset() {
        this.offset = this.beginOffset;
        this.firstValue = true;
    }

    @Override
    public OrdinalIterator copy() {
        return new HashSetOrdinalIterator(this.reader);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    private void nextOffset() {
        ++this.offset;
        if (this.offset >= this.reader.length()) {
            this.offset = 0;
        }
    }

    private void seekBeginByte() {
        while ((this.reader.getByte(this.offset) & 0x80) != 0 || this.reader.getByte(this.offset) == 0) {
            this.nextOffset();
        }
    }
}

