/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.exception.NFGraphException;
import java.util.HashMap;
import java.util.Map;

public class NFCompressedGraphPointers {
    private final Map<String, int[]> pointersByOrdinal = new HashMap<String, int[]>();

    public int getPointer(String nodeType, int ordinal) {
        int[] pointers = this.pointersByOrdinal.get(nodeType);
        if (pointers == null) {
            throw new NFGraphException("Undefined node type: " + nodeType);
        }
        if (ordinal < pointers.length) {
            return pointers[ordinal];
        }
        return -1;
    }

    public void addPointers(String nodeType, int[] pointers) {
        this.pointersByOrdinal.put(nodeType, pointers);
    }

    public int numPointers(String nodeType) {
        return this.pointersByOrdinal.get(nodeType).length;
    }

    public Map<String, int[]> asMap() {
        return this.pointersByOrdinal;
    }
}

