/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.serializer;

import com.netflix.nfgraph.NFGraphModelHolder;
import com.netflix.nfgraph.compressed.NFCompressedGraph;
import com.netflix.nfgraph.compressed.NFCompressedGraphPointers;
import com.netflix.nfgraph.spec.NFGraphSpec;
import com.netflix.nfgraph.spec.NFNodeSpec;
import com.netflix.nfgraph.spec.NFPropertySpec;
import com.netflix.nfgraph.util.ByteArrayReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NFCompressedGraphDeserializer {
    public NFCompressedGraph deserialize(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        NFGraphSpec spec = this.deserializeSpec(dis);
        NFGraphModelHolder models = this.deserializeModels(dis);
        NFCompressedGraphPointers pointers = this.deserializePointers(dis);
        byte[] data = this.deserializeData(dis);
        return new NFCompressedGraph(spec, models, data, pointers);
    }

    private NFGraphSpec deserializeSpec(DataInputStream dis) throws IOException {
        int numNodes = dis.readInt();
        NFNodeSpec[] nodeSpecs = new NFNodeSpec[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            String nodeTypeName = dis.readUTF();
            int numProperties = dis.readInt();
            NFPropertySpec[] propertySpecs = new NFPropertySpec[numProperties];
            for (int j = 0; j < numProperties; ++j) {
                String propertyName = dis.readUTF();
                String toNodeType = dis.readUTF();
                boolean isGlobal = dis.readBoolean();
                boolean isMultiple = dis.readBoolean();
                boolean isHashed = dis.readBoolean();
                propertySpecs[j] = new NFPropertySpec(propertyName, toNodeType, isGlobal, isMultiple, isHashed);
            }
            nodeSpecs[i] = new NFNodeSpec(nodeTypeName, propertySpecs);
        }
        return new NFGraphSpec(nodeSpecs);
    }

    private NFGraphModelHolder deserializeModels(DataInputStream dis) throws IOException {
        int numModels = dis.readInt();
        NFGraphModelHolder modelHolder = new NFGraphModelHolder();
        for (int i = 0; i < numModels; ++i) {
            modelHolder.getModelIndex(dis.readUTF());
        }
        return modelHolder;
    }

    private NFCompressedGraphPointers deserializePointers(DataInputStream dis) throws IOException {
        int numTypes = dis.readInt();
        NFCompressedGraphPointers pointers = new NFCompressedGraphPointers();
        for (int i = 0; i < numTypes; ++i) {
            String nodeType = dis.readUTF();
            pointers.addPointers(nodeType, this.deserializePointerArray(dis));
        }
        return pointers;
    }

    private int[] deserializePointerArray(DataInputStream dis) throws IOException {
        int numNodes = dis.readInt();
        int numBytes = dis.readInt();
        byte[] data = new byte[numBytes];
        int[] pointers = new int[numNodes];
        dis.readFully(data);
        ByteArrayReader reader = new ByteArrayReader(data, 0);
        int currentPointer = 0;
        for (int i = 0; i < numNodes; ++i) {
            int vInt = reader.readVInt();
            pointers[i] = vInt == -1 ? -1 : (currentPointer += vInt);
        }
        return pointers;
    }

    private byte[] deserializeData(DataInputStream dis) throws IOException {
        int dataLength = dis.readInt();
        byte[] data = new byte[dataLength];
        dis.readFully(data);
        return data;
    }
}

