/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.spec;

import com.netflix.nfgraph.exception.NFGraphException;
import com.netflix.nfgraph.spec.NFNodeSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NFGraphSpec
implements Iterable<NFNodeSpec> {
    private final Map<String, NFNodeSpec> nodeSpecs = new HashMap<String, NFNodeSpec>();

    public NFGraphSpec() {
    }

    public NFGraphSpec(NFNodeSpec ... nodeTypes) {
        this();
        for (NFNodeSpec spec : nodeTypes) {
            this.addNodeSpec(spec);
        }
    }

    public NFNodeSpec getNodeSpec(String nodeType) {
        NFNodeSpec spec = this.nodeSpecs.get(nodeType);
        if (spec == null) {
            throw new NFGraphException("Node spec " + nodeType + " is undefined");
        }
        return spec;
    }

    public void addNodeSpec(NFNodeSpec nodeSpec) {
        this.nodeSpecs.put(nodeSpec.getNodeTypeName(), nodeSpec);
    }

    public int size() {
        return this.nodeSpecs.size();
    }

    public List<String> getNodeTypes() {
        return new ArrayList<String>(this.nodeSpecs.keySet());
    }

    @Override
    public Iterator<NFNodeSpec> iterator() {
        return this.nodeSpecs.values().iterator();
    }
}

