/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.spec;

public class NFPropertySpec {
    public static final int GLOBAL = 0;
    public static final int MODEL_SPECIFIC = 1;
    public static final int MULTIPLE = 0;
    public static final int SINGLE = 2;
    public static final int HASH = 4;
    public static final int COMPACT = 0;
    private final boolean isGlobal;
    private final boolean isMultiple;
    private final boolean isHashed;
    private final String name;
    private final String toNodeType;
    private int propertyIndex;

    public NFPropertySpec(String name, String toNodeType, int flags) {
        this.name = name;
        this.toNodeType = toNodeType;
        this.isGlobal = (flags & 1) == 0;
        this.isMultiple = (flags & 2) == 0;
        this.isHashed = (flags & 4) != 0;
    }

    public NFPropertySpec(String name, String toNodeType, boolean isGlobal, boolean isMultiple, boolean isHashed) {
        this.name = name;
        this.toNodeType = toNodeType;
        this.isGlobal = isGlobal;
        this.isMultiple = isMultiple;
        this.isHashed = isHashed;
    }

    public boolean isConnectionModelSpecific() {
        return !this.isGlobal;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public boolean isSingle() {
        return !this.isMultiple;
    }

    public boolean isHashed() {
        return this.isHashed;
    }

    public boolean isCompact() {
        return !this.isHashed;
    }

    public String getName() {
        return this.name;
    }

    public String getToNodeType() {
        return this.toNodeType;
    }

    void setPropertyIndex(int propertyIndex) {
        this.propertyIndex = propertyIndex;
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }
}

