/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class ByteArrayBuffer {
    private byte[] data;
    private int pointer;

    public ByteArrayBuffer() {
        this(1024);
    }

    public ByteArrayBuffer(int initialSize) {
        this.data = new byte[initialSize];
        this.pointer = 0;
    }

    public void write(ByteArrayBuffer buf) {
        while (this.data.length < this.pointer + buf.length()) {
            this.grow();
        }
        System.arraycopy(buf.backingArray(), 0, this.data, this.pointer, buf.length());
        this.pointer += buf.length();
    }

    public void writeVInt(int value) {
        if (value < 0) {
            this.writeByte((byte)-128);
            return;
        }
        if (value > 0xFFFFFFF) {
            this.writeByte((byte)(0x80 | value >>> 28));
        }
        if (value > 0x1FFFFF) {
            this.writeByte((byte)(0x80 | value >>> 21 & 0x7F));
        }
        if (value > 16383) {
            this.writeByte((byte)(0x80 | value >>> 14 & 0x7F));
        }
        if (value > 127) {
            this.writeByte((byte)(0x80 | value >>> 7 & 0x7F));
        }
        this.writeByte((byte)(value & 0x7F));
    }

    public int length() {
        return this.pointer;
    }

    public void reset() {
        this.pointer = 0;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.length());
    }

    public void writeByte(byte b) {
        if (this.pointer == this.data.length) {
            this.grow();
        }
        this.data[this.pointer++] = b;
    }

    public void write(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.writeByte(data[i]);
        }
    }

    public void copyTo(OutputStream os) throws IOException {
        os.write(this.data, 0, this.pointer);
    }

    private void grow() {
        this.data = Arrays.copyOf(this.data, this.data.length * 3 / 2);
    }

    private byte[] backingArray() {
        return this.data;
    }
}

