/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.util;

public class ByteArrayReader {
    private final byte[] data;
    private int pointer;
    private int startByte;
    private int endByte = Integer.MAX_VALUE;

    public ByteArrayReader(byte[] data, int pointer) {
        this.data = data;
        this.pointer = pointer;
        this.startByte = pointer;
        this.endByte = data.length;
    }

    private ByteArrayReader(byte[] data, int startByte, int endByte) {
        this.data = data;
        this.startByte = startByte;
        this.endByte = endByte;
        this.pointer = startByte;
    }

    public byte getByte(int offset) {
        return this.data[this.startByte + offset];
    }

    public void setPointer(int pointer) {
        this.pointer = pointer;
    }

    public void skip(int numBytes) {
        this.pointer += numBytes;
    }

    public int readVInt() {
        if (this.pointer >= this.endByte) {
            return -1;
        }
        byte b = this.readByte();
        if (b == -128) {
            return -1;
        }
        int value = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            value <<= 7;
            value |= b & 0x7F;
        }
        return value;
    }

    public byte readByte() {
        return this.data[this.pointer++];
    }

    public void setRemainingBytes(int remainingBytes) {
        this.startByte = this.pointer;
        this.endByte = this.pointer + remainingBytes;
    }

    public void reset() {
        this.pointer = this.startByte;
    }

    public int length() {
        return this.endByte - this.startByte;
    }

    public ByteArrayReader copy() {
        return new ByteArrayReader(this.data, this.startByte, this.endByte);
    }
}

