/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.util;

import com.netflix.nfgraph.util.ArrayIterator;
import com.netflix.nfgraph.util.Mixer;
import java.util.Arrays;
import java.util.Iterator;

public class OrdinalMap<T>
implements Iterable<T> {
    private int[] hashedOrdinalArray;
    private T[] objectsByOrdinal;
    private int size;

    public OrdinalMap() {
        this(10);
    }

    public OrdinalMap(int expectedSize) {
        int mapArraySize = 1 << 32 - Integer.numberOfLeadingZeros(expectedSize * 4 / 3);
        int ordinalArraySize = mapArraySize * 3 / 4;
        this.hashedOrdinalArray = this.newHashedOrdinalArray(mapArraySize);
        this.objectsByOrdinal = new Object[ordinalArraySize];
    }

    public int add(T obj) {
        int ordinal = this.get(obj);
        if (ordinal != -1) {
            return ordinal;
        }
        if (this.size == this.objectsByOrdinal.length) {
            this.growCapacity();
        }
        this.objectsByOrdinal[this.size] = obj;
        this.hashOrdinalIntoArray(this.size, this.hashedOrdinalArray);
        return this.size++;
    }

    public int get(T obj) {
        int hash = Mixer.hashInt(obj.hashCode());
        int bucket = hash % this.hashedOrdinalArray.length;
        int ordinal = this.hashedOrdinalArray[bucket];
        while (ordinal != -1) {
            if (this.objectsByOrdinal[ordinal].equals(obj)) {
                return ordinal;
            }
            bucket = (bucket + 1) % this.hashedOrdinalArray.length;
            ordinal = this.hashedOrdinalArray[bucket];
        }
        return -1;
    }

    public T get(int ordinal) {
        if (ordinal >= this.size) {
            return null;
        }
        return this.objectsByOrdinal[ordinal];
    }

    public int size() {
        return this.size;
    }

    private void growCapacity() {
        int[] newHashedOrdinalArray = this.newHashedOrdinalArray(this.hashedOrdinalArray.length * 2);
        for (int i = 0; i < this.objectsByOrdinal.length; ++i) {
            this.hashOrdinalIntoArray(i, newHashedOrdinalArray);
        }
        this.objectsByOrdinal = Arrays.copyOf(this.objectsByOrdinal, this.objectsByOrdinal.length * 2);
        this.hashedOrdinalArray = newHashedOrdinalArray;
    }

    private void hashOrdinalIntoArray(int ordinal, int[] hashedOrdinalArray) {
        int hash = Mixer.hashInt(this.objectsByOrdinal[ordinal].hashCode());
        int bucket = hash % hashedOrdinalArray.length;
        while (hashedOrdinalArray[bucket] != -1) {
            bucket = (bucket + 1) % hashedOrdinalArray.length;
        }
        hashedOrdinalArray[bucket] = ordinal;
    }

    private int[] newHashedOrdinalArray(int length) {
        int[] arr = new int[length];
        Arrays.fill(arr, -1);
        return arr;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.objectsByOrdinal, this.size);
    }
}

