/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.serialization;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.netflix.serialization.Deserializer;
import com.netflix.serialization.Serializer;
import com.netflix.serialization.TypeDef;
import com.netflix.serialization.TypeTokenBasedReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;

public class JacksonCodec<T>
implements Serializer<T>,
Deserializer<T> {
    private static final JacksonCodec instance = new JacksonCodec();
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public T deserialize(InputStream in, TypeDef<T> type) throws IOException {
        if (String.class.equals(type.getRawType())) {
            return (T)CharStreams.toString((Readable)new InputStreamReader(in, Charsets.UTF_8));
        }
        return (T)this.mapper.readValue(in, new TypeTokenBasedReference<T>(type));
    }

    @Override
    public void serialize(OutputStream out, T object, TypeDef<?> type) throws IOException {
        if (type == null) {
            this.mapper.writeValue(out, object);
        } else {
            ObjectWriter writer = this.mapper.writerWithType(new TypeTokenBasedReference(type));
            writer.writeValue(out, object);
        }
    }

    public static final <T> JacksonCodec<T> getInstance() {
        return instance;
    }
}

