/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.atlas.impl.DataExpr;
import com.netflix.spectator.atlas.impl.Query;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public final class Parser {
    private Parser() {
    }

    public static DataExpr parseDataExpr(String expr) {
        try {
            return (DataExpr)Parser.parse(expr);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("invalid data expression: " + expr, e);
        }
    }

    public static Query parseQuery(String expr) {
        try {
            return (Query)Parser.parse(expr);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("invalid query expression: " + expr, e);
        }
    }

    private static Object parse(String expr) {
        int depth = 0;
        ArrayList<String> vs = null;
        String[] parts = expr.split(",");
        ArrayDeque<Object> stack = new ArrayDeque<Object>(parts.length);
        block52: for (String p : parts) {
            String token = p.trim();
            if (token.isEmpty()) continue;
            if (!(vs == null || depth <= 0 && ")".equals(token))) {
                if ("(".equals(token)) {
                    ++depth;
                } else if (")".equals(token)) {
                    --depth;
                }
                vs.add(token);
                continue;
            }
            switch (token) {
                case "(": {
                    vs = new ArrayList<String>();
                    continue block52;
                }
                case ")": {
                    if (vs == null) {
                        throw new IllegalArgumentException("unmatched closing paren: " + expr);
                    }
                    stack.push(vs);
                    vs = null;
                    depth = 0;
                    continue block52;
                }
                case ":true": {
                    stack.push(Query.TRUE);
                    continue block52;
                }
                case ":false": {
                    stack.push(Query.FALSE);
                    continue block52;
                }
                case ":and": {
                    Query q2 = (Query)stack.pop();
                    Query q1 = (Query)stack.pop();
                    stack.push(new Query.And(q1, q2));
                    continue block52;
                }
                case ":or": {
                    Query q2 = (Query)stack.pop();
                    Query q1 = (Query)stack.pop();
                    stack.push(new Query.Or(q1, q2));
                    continue block52;
                }
                case ":not": {
                    Query q = (Query)stack.pop();
                    stack.push(new Query.Not(q));
                    continue block52;
                }
                case ":has": {
                    String k = (String)stack.pop();
                    stack.push(new Query.Has(k));
                    continue block52;
                }
                case ":eq": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.Equal(k, v));
                    continue block52;
                }
                case ":in": {
                    List tmp = (List)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.In(k, new TreeSet<String>(tmp)));
                    continue block52;
                }
                case ":lt": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.LessThan(k, v));
                    continue block52;
                }
                case ":le": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.LessThanEqual(k, v));
                    continue block52;
                }
                case ":gt": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.GreaterThan(k, v));
                    continue block52;
                }
                case ":ge": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.GreaterThanEqual(k, v));
                    continue block52;
                }
                case ":re": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.Regex(k, v));
                    continue block52;
                }
                case ":reic": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.Regex(k, v, true, ":reic"));
                    continue block52;
                }
                case ":all": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.All(q));
                    continue block52;
                }
                case ":sum": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Sum(q));
                    continue block52;
                }
                case ":min": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Min(q));
                    continue block52;
                }
                case ":max": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Max(q));
                    continue block52;
                }
                case ":count": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Count(q));
                    continue block52;
                }
                case ":by": {
                    List tmp = (List)stack.pop();
                    DataExpr.AggregateFunction af = (DataExpr.AggregateFunction)stack.pop();
                    stack.push(new DataExpr.GroupBy(af, tmp));
                    continue block52;
                }
                case ":rollup-drop": {
                    List tmp = (List)stack.pop();
                    DataExpr.AggregateFunction af = (DataExpr.AggregateFunction)stack.pop();
                    stack.push(new DataExpr.DropRollup(af, tmp));
                    continue block52;
                }
                case ":rollup-keep": {
                    List tmp = (List)stack.pop();
                    DataExpr.AggregateFunction af = (DataExpr.AggregateFunction)stack.pop();
                    stack.push(new DataExpr.KeepRollup(af, tmp));
                    continue block52;
                }
                default: {
                    if (token.startsWith(":")) {
                        throw new IllegalArgumentException("unknown word '" + token + "'");
                    }
                    stack.push(token);
                }
            }
        }
        Object obj = stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalArgumentException("too many items remaining on stack: " + stack);
        }
        return obj;
    }
}

