/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.PatternMatcher;
import com.netflix.spectator.impl.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface Query {
    public static final Query TRUE = new Query(){

        @Override
        public boolean matches(Map<String, String> tags) {
            return true;
        }

        public String toString() {
            return ":true";
        }
    };
    public static final Query FALSE = new Query(){

        @Override
        public boolean matches(Map<String, String> tags) {
            return false;
        }

        public String toString() {
            return ":false";
        }
    };

    public static Map<String, String> toMap(Id id) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Tag t : id.tags()) {
            tags.put(t.key(), t.value());
        }
        tags.put("name", id.name());
        return tags;
    }

    public boolean matches(Map<String, String> var1);

    default public boolean matches(Id id) {
        return this.matches(Query.toMap(id));
    }

    default public Map<String, String> exactTags() {
        return Collections.emptyMap();
    }

    default public Query and(Query q) {
        return new And(this, q);
    }

    default public Query or(Query q) {
        return new Or(this, q);
    }

    default public Query not() {
        return new Not(this);
    }

    public static final class Regex
    implements Query {
        private final String k;
        private final String v;
        private final PatternMatcher pattern;
        private final String name;

        Regex(String k, String v) {
            this(k, v, false, ":re");
        }

        Regex(String k, String v, boolean ignoreCase, String name) {
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
            this.v = (String)Preconditions.checkNotNull((Object)v, (String)"v");
            this.pattern = ignoreCase ? PatternMatcher.compile((String)("^" + v)).ignoreCase() : PatternMatcher.compile((String)("^" + v));
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            String s = tags.get(this.k);
            return s != null && this.pattern.matches(s);
        }

        public String toString() {
            return this.k + "," + this.v + "," + this.name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Regex)) {
                return false;
            }
            Regex other = (Regex)obj;
            return this.k.equals(other.k) && this.v.equals(other.v) && this.pattern.equals(other.pattern) && this.name.equals(other.name);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            result = 31 * result + this.pattern.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }

    public static final class GreaterThanEqual
    implements Query {
        private final String k;
        private final String v;

        GreaterThanEqual(String k, String v) {
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
            this.v = (String)Preconditions.checkNotNull((Object)v, (String)"v");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            String s = tags.get(this.k);
            return s != null && s.compareTo(this.v) >= 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:ge";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof GreaterThanEqual)) {
                return false;
            }
            GreaterThanEqual other = (GreaterThanEqual)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class GreaterThan
    implements Query {
        private final String k;
        private final String v;

        GreaterThan(String k, String v) {
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
            this.v = (String)Preconditions.checkNotNull((Object)v, (String)"v");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            String s = tags.get(this.k);
            return s != null && s.compareTo(this.v) > 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:gt";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof GreaterThan)) {
                return false;
            }
            GreaterThan other = (GreaterThan)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class LessThanEqual
    implements Query {
        private final String k;
        private final String v;

        LessThanEqual(String k, String v) {
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
            this.v = (String)Preconditions.checkNotNull((Object)v, (String)"v");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            String s = tags.get(this.k);
            return s != null && s.compareTo(this.v) <= 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:le";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof LessThanEqual)) {
                return false;
            }
            LessThanEqual other = (LessThanEqual)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class LessThan
    implements Query {
        private final String k;
        private final String v;

        LessThan(String k, String v) {
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
            this.v = (String)Preconditions.checkNotNull((Object)v, (String)"v");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            String s = tags.get(this.k);
            return s != null && s.compareTo(this.v) < 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:lt";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof LessThan)) {
                return false;
            }
            LessThan other = (LessThan)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class In
    implements Query {
        private final String k;
        private final Set<String> vs;

        In(String k, Set<String> vs) {
            Preconditions.checkArg((!vs.isEmpty() ? 1 : 0) != 0, (String)"list of values for :in cannot be empty");
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
            this.vs = (Set)Preconditions.checkNotNull(vs, (String)"vs");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            String s = tags.get(this.k);
            return s != null && this.vs.contains(tags.get(this.k));
        }

        public String toString() {
            String values = this.vs.stream().collect(Collectors.joining(","));
            return this.k + ",(," + values + ",),:in";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof In)) {
                return false;
            }
            In other = (In)obj;
            return this.k.equals(other.k) && this.vs.equals(other.vs);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.vs.hashCode();
            return result;
        }
    }

    public static final class Equal
    implements Query {
        private final String k;
        private final String v;

        Equal(String k, String v) {
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
            this.v = (String)Preconditions.checkNotNull((Object)v, (String)"v");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return this.v.equals(tags.get(this.k));
        }

        @Override
        public Map<String, String> exactTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put(this.k, this.v);
            return tags;
        }

        public String toString() {
            return this.k + "," + this.v + ",:eq";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Equal)) {
                return false;
            }
            Equal other = (Equal)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class Has
    implements Query {
        private final String k;

        Has(String k) {
            this.k = (String)Preconditions.checkNotNull((Object)k, (String)"k");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return tags.containsKey(this.k);
        }

        public String toString() {
            return this.k + ",:has";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Has)) {
                return false;
            }
            Has other = (Has)obj;
            return this.k.equals(other.k);
        }

        public int hashCode() {
            return this.k.hashCode();
        }
    }

    public static final class Not
    implements Query {
        private final Query q;

        Not(Query q) {
            this.q = (Query)Preconditions.checkNotNull((Object)q, (String)"q");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return !this.q.matches(tags);
        }

        public String toString() {
            return this.q + ",:not";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Not)) {
                return false;
            }
            Not other = (Not)obj;
            return this.q.equals(other.q);
        }

        public int hashCode() {
            return this.q.hashCode();
        }
    }

    public static final class Or
    implements Query {
        private final Query q1;
        private final Query q2;

        Or(Query q1, Query q2) {
            this.q1 = (Query)Preconditions.checkNotNull((Object)q1, (String)"q1");
            this.q2 = (Query)Preconditions.checkNotNull((Object)q2, (String)"q2");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return this.q1.matches(tags) || this.q2.matches(tags);
        }

        public String toString() {
            return this.q1 + "," + this.q2 + ",:or";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Or)) {
                return false;
            }
            Or other = (Or)obj;
            return this.q1.equals(other.q1) && this.q2.equals(other.q2);
        }

        public int hashCode() {
            int result = this.q1.hashCode();
            result = 31 * result + this.q2.hashCode();
            return result;
        }
    }

    public static final class And
    implements Query {
        private final Query q1;
        private final Query q2;

        And(Query q1, Query q2) {
            this.q1 = (Query)Preconditions.checkNotNull((Object)q1, (String)"q1");
            this.q2 = (Query)Preconditions.checkNotNull((Object)q2, (String)"q2");
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return this.q1.matches(tags) && this.q2.matches(tags);
        }

        @Override
        public Map<String, String> exactTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.putAll(this.q1.exactTags());
            tags.putAll(this.q2.exactTags());
            return tags;
        }

        public String toString() {
            return this.q1 + "," + this.q2 + ",:and";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof And)) {
                return false;
            }
            And other = (And)obj;
            return this.q1.equals(other.q1) && this.q2.equals(other.q2);
        }

        public int hashCode() {
            int result = this.q1.hashCode();
            result = 31 * result + this.q2.hashCode();
            return result;
        }
    }
}

