/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasCounter;
import com.netflix.spectator.atlas.AtlasDistributionSummary;
import com.netflix.spectator.atlas.AtlasGauge;
import com.netflix.spectator.atlas.AtlasMaxGauge;
import com.netflix.spectator.atlas.AtlasTimer;
import com.netflix.spectator.atlas.StepClock;
import com.netflix.spectator.atlas.SubscriptionManager;
import com.netflix.spectator.atlas.impl.EvalPayload;
import com.netflix.spectator.atlas.impl.Evaluator;
import com.netflix.spectator.atlas.impl.MeasurementSerializer;
import com.netflix.spectator.atlas.impl.PublishPayload;
import com.netflix.spectator.atlas.impl.Subscription;
import com.netflix.spectator.atlas.impl.TagsValuePair;
import com.netflix.spectator.impl.AsciiSet;
import com.netflix.spectator.impl.Scheduler;
import com.netflix.spectator.ipc.http.HttpClient;
import com.netflix.spectator.ipc.http.HttpResponse;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class AtlasRegistry
extends AbstractRegistry {
    private static final String CLOCK_SKEW_TIMER = "spectator.atlas.clockSkew";
    private final Clock stepClock;
    private final AtlasConfig config;
    private final Duration step;
    private final long stepMillis;
    private final long meterTTL;
    private final URI uri;
    private final Duration configRefreshFrequency;
    private final URI evalUri;
    private final int connectTimeout;
    private final int readTimeout;
    private final int batchSize;
    private final int numThreads;
    private final Map<String, String> commonTags;
    private final AsciiSet charset;
    private final Map<String, AsciiSet> overrides;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final HttpClient client;
    private Scheduler scheduler;
    private final SubscriptionManager subManager;

    public AtlasRegistry(Clock clock, AtlasConfig config) {
        super(clock, (RegistryConfig)config);
        this.config = config;
        this.stepClock = new StepClock(clock, config.step().toMillis());
        this.step = config.step();
        this.stepMillis = this.step.toMillis();
        this.meterTTL = config.meterTTL().toMillis();
        this.uri = URI.create(config.uri());
        this.configRefreshFrequency = config.configRefreshFrequency();
        this.evalUri = URI.create(config.evalUri());
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.batchSize = config.batchSize();
        this.numThreads = config.numThreads();
        this.commonTags = new TreeMap<String, String>(config.commonTags());
        this.charset = AsciiSet.fromPattern((String)config.validTagCharacters());
        this.overrides = config.validTagValueCharacters().keySet().stream().collect(Collectors.toMap(k -> k, AsciiSet::fromPattern));
        SimpleModule module = new SimpleModule().addSerializer(Measurement.class, (JsonSerializer)new MeasurementSerializer(this.charset, this.overrides));
        this.jsonMapper = new ObjectMapper(new JsonFactory()).registerModule((Module)module);
        this.smileMapper = new ObjectMapper((JsonFactory)new SmileFactory()).registerModule((Module)module);
        this.client = HttpClient.create((Registry)this);
        this.subManager = new SubscriptionManager(this.jsonMapper, this.client, clock, config);
    }

    public void start() {
        if (this.scheduler == null) {
            Scheduler.Options options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_RATE_SKIP_IF_LONG, this.step).withInitialDelay(Duration.ofMillis(this.getInitialDelay(this.stepMillis))).withStopOnFailure(false);
            this.scheduler = new Scheduler((Registry)this, "spectator-reg-atlas", this.numThreads);
            this.scheduler.schedule(options, this::collectData);
            this.logger.info("started collecting metrics every {} reporting to {}", (Object)this.step, (Object)this.uri);
            this.logger.info("common tags: {}", this.commonTags);
            Scheduler.Options subOptions = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_DELAY, this.configRefreshFrequency).withStopOnFailure(false);
            this.scheduler.schedule(subOptions, this::fetchSubscriptions);
        } else {
            this.logger.warn("registry already started, ignoring duplicate request");
        }
    }

    long getInitialDelay(long stepSize) {
        long offset;
        long stepBoundary;
        long now = this.clock().wallTime();
        long delay = now - (stepBoundary = now / stepSize * stepSize);
        if (delay < (offset = stepSize / 10L)) {
            return delay + offset;
        }
        if (delay > stepSize - offset) {
            return stepSize - offset;
        }
        return delay;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            this.logger.info("stopped collecting metrics every {}ms reporting to {}", (Object)this.step, (Object)this.uri);
        } else {
            this.logger.warn("registry stopped, but was never started");
        }
    }

    void collectData() {
        if (this.config.lwcEnabled()) {
            try {
                this.handleSubscriptions();
            }
            catch (Exception e) {
                this.logger.warn("failed to handle subscriptions", (Throwable)e);
            }
        } else {
            this.logger.debug("lwc is disabled, skipping subscriptions");
        }
        if (this.config.enabled()) {
            try {
                for (List<Measurement> batch : this.getBatches()) {
                    HttpResponse res;
                    Instant date;
                    PublishPayload p = new PublishPayload(this.commonTags, batch);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("publish payload: {}", (Object)this.jsonMapper.writeValueAsString((Object)p));
                    }
                    this.recordClockSkew((date = (res = this.client.post(this.uri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withContent("application/x-jackson-smile", this.smileMapper.writeValueAsBytes((Object)p)).send()).dateHeader("Date")) == null ? 0L : date.toEpochMilli());
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics (uri={})", (Object)this.uri, (Object)e);
            }
        } else {
            this.logger.debug("publishing is disabled, skipping collection");
        }
        this.removeExpiredMeters();
    }

    public void removeExpiredMeters() {
        super.removeExpiredMeters();
    }

    private void handleSubscriptions() {
        List<Subscription> subs = this.subManager.subscriptions();
        if (!subs.isEmpty()) {
            List<TagsValuePair> ms = this.getMeasurements().map(this::newTagsValuePair).collect(Collectors.toList());
            Evaluator evaluator = new Evaluator().addGroupSubscriptions("local", subs);
            EvalPayload payload = evaluator.eval("local", this.stepClock.wallTime(), ms);
            try {
                String json = this.jsonMapper.writeValueAsString((Object)payload);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("eval payload: {}", (Object)json);
                }
                this.client.post(this.evalUri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withJsonContent(json).send().decompress();
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics for subscriptions (uri={})", (Object)this.evalUri, (Object)e);
            }
        }
    }

    private void fetchSubscriptions() {
        if (this.config.lwcEnabled()) {
            this.subManager.refresh();
        } else {
            this.logger.debug("lwc is disabled, skipping subscription config refresh");
        }
    }

    private void recordClockSkew(long responseTimestamp) {
        if (responseTimestamp == 0L) {
            this.logger.debug("no date timestamp on response, cannot record skew");
        } else {
            long delta = this.clock().wallTime() - responseTimestamp;
            if (delta >= 0L) {
                this.timer(CLOCK_SKEW_TIMER, new String[]{"id", "fast"}).record(delta, TimeUnit.MILLISECONDS);
            } else {
                this.timer(CLOCK_SKEW_TIMER, new String[]{"id", "slow"}).record(-delta, TimeUnit.MILLISECONDS);
            }
            this.logger.debug("clock skew between client and server: {}ms", (Object)delta);
        }
    }

    private Map<String, String> toMap(Id id) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Tag t : id.tags()) {
            String k = this.charset.replaceNonMembers(t.key(), '_');
            String v = this.overrides.getOrDefault(k, this.charset).replaceNonMembers(t.value(), '_');
            tags.put(k, v);
        }
        String name = this.overrides.getOrDefault("name", this.charset).replaceNonMembers(id.name(), '_');
        tags.put("name", name);
        return tags;
    }

    private TagsValuePair newTagsValuePair(Measurement m) {
        Map<String, String> tags = this.toMap(m.id());
        tags.putAll(this.commonTags);
        return new TagsValuePair(tags, m.value());
    }

    Stream<Measurement> getMeasurements() {
        return this.stream().filter(m -> !m.hasExpired()).flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).filter(m -> !Double.isNaN(m.value()));
    }

    List<List<Measurement>> getBatches() {
        ArrayList<List<Measurement>> batches = new ArrayList<List<Measurement>>();
        List ms = this.getMeasurements().collect(Collectors.toList());
        for (int i = 0; i < ms.size(); i += this.batchSize) {
            List batch = ms.subList(i, Math.min(ms.size(), i + this.batchSize));
            batches.add(batch);
        }
        return batches;
    }

    protected Counter newCounter(Id id) {
        return new AtlasCounter(id, this.clock(), this.meterTTL, this.stepMillis);
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        return new AtlasDistributionSummary(id, this.clock(), this.meterTTL, this.stepMillis);
    }

    protected Timer newTimer(Id id) {
        return new AtlasTimer(id, this.clock(), this.meterTTL, this.stepMillis);
    }

    protected Gauge newGauge(Id id) {
        return new AtlasGauge(id, this.stepClock, this.meterTTL);
    }

    protected Gauge newMaxGauge(Id id) {
        return new AtlasMaxGauge(id, this.clock(), this.meterTTL, this.stepMillis);
    }
}

