/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.Builder;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.ScalarOverlay;
import com.networknt.jsonoverlay.SerializationOptions;

public final class ObjectOverlay
extends ScalarOverlay<Object> {
    public static OverlayFactory<Object> factory = new OverlayFactory<Object>(){

        @Override
        protected Class<ObjectOverlay> getOverlayClass() {
            return ObjectOverlay.class;
        }

        public ObjectOverlay _create(Object value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new ObjectOverlay(value, parent, refMgr);
        }

        public ObjectOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new ObjectOverlay(json, (JsonOverlay)parent, refMgr);
        }
    };

    private ObjectOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
    }

    private ObjectOverlay(Object value, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(value, parent, factory, refMgr);
    }

    @Override
    protected Object _fromJson(JsonNode json) {
        return json.isMissingNode() ? null : mapper.convertValue((Object)json, Object.class);
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? (JsonNode)mapper.convertValue(this.value, JsonNode.class) : ObjectOverlay._jsonMissing();
    }

    @Override
    protected OverlayFactory<Object> _getFactory() {
        return factory;
    }

    public static Builder<Object> builder(JsonOverlay<?> modelMember) {
        return new Builder<Object>(factory, modelMember);
    }

    public static JsonOverlay<Object> create(JsonOverlay<?> modelMember) {
        return ObjectOverlay.builder(modelMember).build();
    }

    public static JsonOverlay<Object> create(Object value, JsonOverlay<?> modelMember) {
        JsonOverlay<Object> result = ObjectOverlay.create(modelMember);
        result._set(value);
        return result;
    }
}

