/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.ScalarOverlay;
import com.networknt.jsonoverlay.SerializationOptions;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class PrimitiveOverlay
extends ScalarOverlay<Object> {
    public static OverlayFactory<Object> factory = new OverlayFactory<Object>(){

        @Override
        protected Class<PrimitiveOverlay> getOverlayClass() {
            return PrimitiveOverlay.class;
        }

        public PrimitiveOverlay _create(Object value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new PrimitiveOverlay(value, parent, refMgr);
        }

        public PrimitiveOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new PrimitiveOverlay(json, (JsonOverlay)parent, refMgr);
        }
    };

    private PrimitiveOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
    }

    private PrimitiveOverlay(Object value, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(value, parent, factory, refMgr);
    }

    @Override
    protected Object _fromJson(JsonNode json) {
        if (json.isTextual()) {
            return json.textValue();
        }
        if (json.isNumber()) {
            return json.numberValue();
        }
        if (json.isBoolean()) {
            return json.booleanValue();
        }
        return null;
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        if (this.value == null) {
            return PrimitiveOverlay._jsonMissing();
        }
        if (this.value instanceof String) {
            return PrimitiveOverlay._jsonScalar((String)this.value);
        }
        if (this.value instanceof BigDecimal) {
            return PrimitiveOverlay._jsonScalar((BigDecimal)this.value);
        }
        if (this.value instanceof BigInteger) {
            return PrimitiveOverlay._jsonScalar((BigInteger)this.value);
        }
        if (this.value instanceof Byte) {
            return PrimitiveOverlay._jsonScalar((Byte)this.value);
        }
        if (this.value instanceof Double) {
            return PrimitiveOverlay._jsonScalar((Double)this.value);
        }
        if (this.value instanceof Float) {
            return PrimitiveOverlay._jsonScalar(((Float)this.value).floatValue());
        }
        if (this.value instanceof Integer) {
            return PrimitiveOverlay._jsonScalar((Integer)this.value);
        }
        if (this.value instanceof Long) {
            return PrimitiveOverlay._jsonScalar((Long)this.value);
        }
        if (this.value instanceof Short) {
            return PrimitiveOverlay._jsonScalar((Short)this.value);
        }
        return null;
    }

    @Override
    protected OverlayFactory<Object> _getFactory() {
        return factory;
    }
}

